/*
 * Decompiled with CFR 0.152.
 */
package com.github.edouardswiac.zerotier;

import com.github.edouardswiac.zerotier.ZTService;
import com.github.edouardswiac.zerotier.api.ZTNetwork;
import com.github.edouardswiac.zerotier.api.ZTNetworkMember;
import com.github.edouardswiac.zerotier.api.ZTStatus;
import com.github.edouardswiac.zerotier.exceptions.ZTClientException;
import com.github.edouardswiac.zerotier.exceptions.ZTServiceException;
import com.github.edouardswiac.zerotier.interceptors.AuthenticationInterceptor;
import com.github.edouardswiac.zerotier.interceptors.LoggingInterceptor;
import com.github.edouardswiac.zerotier.interceptors.UserAgentInterceptor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZTServiceImpl
implements ZTService {
    private final OkHttpClient client;
    private final Gson gson = new Gson();
    private final HttpUrl baseApiUrl;
    private static final Logger LOG = LoggerFactory.getLogger((String)"HTTP Client");
    private static final String USER_AGENT = String.format("ZeroTier API Java Client v%s <https://github.com/edouardswiac/zerotier-api-java>", "0.6");
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public ZTServiceImpl(String apiAccessToken) {
        this("https://my.zerotier.com/api/", apiAccessToken);
    }

    public ZTServiceImpl(String ztCentralUrl, String apiAccessToken) {
        this.client = new OkHttpClient();
        this.client.interceptors().add(new UserAgentInterceptor(USER_AGENT));
        this.client.interceptors().add(new AuthenticationInterceptor(apiAccessToken));
        this.client.interceptors().add(new LoggingInterceptor(LOG));
        this.baseApiUrl = HttpUrl.parse((String)ztCentralUrl);
    }

    @Override
    public void createNetwork(ZTNetwork network) {
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").build();
        Request request = new Request.Builder().url(targetUrl).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)this.gson.toJson((Object)network))).build();
        this.execute(request);
    }

    @Override
    public List<ZTNetwork> getNetworks() {
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").build();
        Request request = new Request.Builder().url(targetUrl).build();
        return Arrays.asList((Object[])this.get(request, ZTNetwork[].class));
    }

    @Override
    public ZTNetwork getNetwork(@NotNull String networkId) {
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").addPathSegment(networkId).build();
        Request request = new Request.Builder().url(targetUrl).build();
        return this.get(request, ZTNetwork.class);
    }

    @Override
    public void updateNetwork(@NotNull ZTNetwork network) {
        if (network.getId() == null) {
            throw new IllegalArgumentException("network ID must not be null");
        }
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").addPathSegment(network.getId()).build();
        Request request = new Request.Builder().url(targetUrl).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)this.gson.toJson((Object)network))).build();
        this.execute(request);
    }

    @Override
    public void deleteNetwork(@NotNull String networkId) {
        block2: {
            HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").addPathSegment(networkId).build();
            Request request = new Request.Builder().url(targetUrl).delete().build();
            try {
                this.execute(request);
            }
            catch (ZTServiceException ex) {
                if (ex.getCause().getLocalizedMessage().contains("code=500")) break block2;
                throw ex;
            }
        }
    }

    @Override
    public ZTStatus status() {
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("status").build();
        Request request = new Request.Builder().url(targetUrl).build();
        return this.get(request, ZTStatus.class);
    }

    @Override
    public Map<String, Integer> getNetworkMembers(@NotNull String networkId) {
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").addPathSegment(networkId).addPathSegment("member").build();
        Type entityType = new TypeToken<HashMap<String, Integer>>(){}.getType();
        Request request = new Request.Builder().url(targetUrl).build();
        Map membersWithVersion = (Map)this.get(request, entityType);
        return Collections.unmodifiableMap(membersWithVersion);
    }

    @Override
    public void createNetworkMember(@NotNull ZTNetworkMember networkMember) {
        this.updateNetworkMember(networkMember);
    }

    @Override
    public ZTNetworkMember getNetworkMember(@NotNull String networkId, @NotNull String address) {
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").addPathSegment(networkId).addPathSegment("member").addPathSegment(address).build();
        Request request = new Request.Builder().url(targetUrl).build();
        return this.get(request, ZTNetworkMember.class);
    }

    @Override
    public void updateNetworkMember(@NotNull ZTNetworkMember networkMember) {
        if (networkMember.getNetworkId() == null) {
            throw new IllegalArgumentException("network ID must not be null");
        }
        if (networkMember.getNodeId() == null) {
            throw new IllegalArgumentException("node ID must not be null");
        }
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").addPathSegment(networkMember.getNetworkId()).addPathSegment("member").addPathSegment(networkMember.getNodeId()).build();
        Request request = new Request.Builder().url(targetUrl).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)this.gson.toJson((Object)networkMember))).build();
        this.execute(request);
    }

    @Override
    public void deleteNetworkMember(@NotNull String networkId, String address) {
        HttpUrl targetUrl = this.baseApiUrl.newBuilder().addPathSegment("network").addPathSegment(networkId).addPathSegment("member").addPathSegment(address).build();
        Request request = new Request.Builder().url(targetUrl).delete().build();
        this.execute(request);
    }

    Response execute(Request request) {
        try {
            Response response = this.client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            return response;
        }
        catch (IOException e) {
            throw new ZTServiceException(e);
        }
    }

    <T> T get(Request request, Class<T> entityClass) {
        Response response = this.execute(request);
        try {
            return (T)this.gson.fromJson(response.body().charStream(), entityClass);
        }
        catch (IOException e) {
            throw new ZTClientException("cannot deserialize resource into its corresponding bean", e);
        }
    }

    <T> T get(Request request, Type entityClass) {
        Response response = this.execute(request);
        try {
            return (T)this.gson.fromJson(response.body().charStream(), entityClass);
        }
        catch (IOException e) {
            throw new ZTClientException("cannot deserialize resource into its corresponding bean", e);
        }
    }
}

