/*
 * Decompiled with CFR 0.152.
 */
package com.github.edouardswiac.zerotier.interceptors;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;

public final class AuthenticationInterceptor
implements Interceptor {
    private final String apiAccessToken;

    public AuthenticationInterceptor(String apiAccessToken) {
        this.apiAccessToken = apiAccessToken;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (null == this.apiAccessToken || this.apiAccessToken.isEmpty()) {
            return chain.proceed(originalRequest);
        }
        Request requestWithUserAgent = originalRequest.newBuilder().addHeader("Authorization", String.format("Bearer %s", this.apiAccessToken)).build();
        return chain.proceed(requestWithUserAgent);
    }
}

