/*
 * Decompiled with CFR 0.152.
 */
package com.github.edouardswiac.zerotier.interceptors;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;

public final class LoggingInterceptor
implements Interceptor {
    public final Logger log;

    public LoggingInterceptor(Logger logger) {
        this.log = logger;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        this.log.info(String.format("Sending %s %s", request.method(), request.url()));
        if (request.body() != null) {
            Request reqCopy = request.newBuilder().build();
            Buffer reqCopyBuffer = new Buffer();
            reqCopy.body().writeTo((BufferedSink)reqCopyBuffer);
            this.log.info("body: {}", (Object)reqCopyBuffer.readUtf8());
        }
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        this.log.info(String.format("Received HTTP %s for %s in %.1fms%n", response.code(), response.request().url(), (double)(t2 - t1) / 1000000.0));
        return response;
    }
}

