/*
 * Decompiled with CFR 0.152.
 */
package com.github.gonella.gopro.api.core;

import com.github.gonella.gopro.api.core.GoProProtocolParser;
import com.github.gonella.gopro.api.core.Operations;
import com.github.gonella.gopro.api.core.model.BacPacStatus;
import com.github.gonella.gopro.api.core.model.BackPack;
import com.github.gonella.gopro.api.core.model.CamFields;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class GoProHelper {
    public static final boolean LOGGING_ENABLED = false;
    private String mCameraAddress = null;
    private final DefaultHttpClient mClient = this.newInstance();
    private String ipAddress;
    private Integer port;
    private String password;

    public GoProHelper() {
    }

    public GoProHelper(String ipAddress, Integer port, String password) {
        this();
        this.setIpAddress(ipAddress);
        this.setPort(port);
        this.setPassword(password);
        this.mCameraAddress = "http://" + ipAddress + ":" + port;
    }

    private void hexDump(byte[] paramArrayOfByte, String paramString) {
    }

    private boolean passFail(byte[] paramArrayOfByte) {
        boolean bool = false;
        if (paramArrayOfByte != null) {
            int i = paramArrayOfByte.length;
            bool = false;
            if (i > 0) {
                byte j = paramArrayOfByte[0];
                bool = false;
                if (j == 0) {
                    bool = true;
                }
            }
        }
        return bool;
    }

    private boolean sendCommand(Operations paramString) {
        try {
            this.sendGET(this.mCameraAddress + paramString.toString() + "?t=" + this.getToken());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean deleteFilesOnSd() {
        return this.sendCommand(Operations.CAMERA_DA);
    }

    public boolean deleteLastFileOnSd() {
        return this.sendCommand(Operations.CAMERA_DL);
    }

    public int fromBoolean(boolean paramBoolean) {
        if (paramBoolean) {
            return 1;
        }
        return 0;
    }

    public String getBacPacPassword() {
        try {
            GoProProtocolParser localGoProProtocolParser = new GoProProtocolParser(this.sendGET(this.mCameraAddress + (Object)((Object)Operations.BACPAC_SD)));
            byte[] arrayOfByte = new byte[]{localGoProProtocolParser.extractByte()};
            boolean bool = this.passFail(arrayOfByte);
            String localObject = null;
            if (bool) {
                String str;
                localObject = str = localGoProProtocolParser.extractString();
            }
            return localObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BackPack getBackPackInfo() throws Exception {
        GoProProtocolParser localGoProProtocolParser;
        BackPack localBackPack = new BackPack();
        try {
            byte[] arrayOfByte = this.sendGET("http://" + this.getIpAddress() + (Object)((Object)Operations.BACPAC_CV));
            localGoProProtocolParser = new GoProProtocolParser(arrayOfByte);
            if (localGoProProtocolParser.extractResultCode() != GoProProtocolParser.RESULT_IS_OK) {
                return null;
            }
        }
        catch (Exception localException) {
            throw new Exception("Fail to get backpack info", localException);
        }
        localBackPack.setVersion(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setModel(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setId(localGoProProtocolParser.extractFixedLengthString(2));
        localBackPack.setBootLoaderMajor(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setBootLoaderMinor(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setBootLoaderBuild(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setRevision(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setMajorversion(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setMinorversion(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setBuildversion(localGoProProtocolParser.extractUnsignedByte());
        localBackPack.setWifimac(localGoProProtocolParser.extractFixedLengthString(6));
        localBackPack.setSSID(localGoProProtocolParser.extractString());
        return localBackPack;
    }

    public BacPacStatus getBacpacStatus() throws Exception {
        BacPacStatus localBacPacStatus = new BacPacStatus();
        byte[] arrayOfByte = this.sendGET(this.mCameraAddress + (Object)((Object)Operations.BACPAC_SE) + "?t=" + this.getToken());
        this.hexDump(arrayOfByte, "BacPac SE");
        GoProProtocolParser localGoProProtocolParser = new GoProProtocolParser(arrayOfByte);
        if (localGoProProtocolParser.extractResultCode() != GoProProtocolParser.RESULT_IS_OK) {
            return null;
        }
        localBacPacStatus.setBacPacBattery(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setWifiMode(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setBlueToothMode(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setRSSI(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setShutterStatus(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setAutoPowerOff(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setBlueToothAudioChannel(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setFileServer(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setCameraPower(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setCameraI2CError(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setCameraReady(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setCameraModel(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setCameraProtocolVersion(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setCameraAttached(localGoProProtocolParser.extractUnsignedByte());
        localBacPacStatus.setBOSSReady(localGoProProtocolParser.extractUnsignedByte());
        return localBacPacStatus;
    }

    public int getCameraHLSSegment() {
        try {
            byte[] arrayOfByte = this.sendGET(this.mCameraAddress + (Object)((Object)Operations.CAMERA_HS2) + "?t=" + this.getToken());
            return new GoProProtocolParser(arrayOfByte).extractUnsignedByte();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public CamFields getCameraInfo() {
        GoProProtocolParser localGoProProtocolParser;
        CamFields localCamFields = new CamFields();
        try {
            byte[] arrayOfByte = this.sendGET(this.mCameraAddress + (Object)((Object)Operations.CAMERA_CV) + "?t=" + this.getToken());
            localGoProProtocolParser = new GoProProtocolParser(arrayOfByte);
            if (localGoProProtocolParser.extractResultCode() != GoProProtocolParser.RESULT_IS_OK) {
                return null;
            }
        }
        catch (Exception localException) {
            return null;
        }
        localCamFields.setProtocol(localGoProProtocolParser.extractUnsignedByte());
        localCamFields.setModel(localGoProProtocolParser.extractUnsignedByte());
        localCamFields.setVersion(localGoProProtocolParser.extractString());
        localCamFields.setCamname(localGoProProtocolParser.extractString());
        return localCamFields;
    }

    public String getCameraNameCN() {
        byte[] arrayOfByte;
        String str = this.getIpAddress();
        try {
            arrayOfByte = this.sendGET(this.mCameraAddress + (Object)((Object)Operations.CAMERA_CN) + "?t=" + this.getToken());
            if (arrayOfByte == null || arrayOfByte.length == 0 || arrayOfByte[0] == 1) {
                return str;
            }
        }
        catch (Exception localException) {
            return str;
        }
        int i = arrayOfByte[1];
        int j = 0;
        int k = 2;
        while (j < i) {
            if (k < arrayOfByte.length) {
                str = str + (char)arrayOfByte[k];
            }
            ++j;
            ++k;
        }
        return str;
    }

    public CamFields getCameraSettings() throws Exception {
        try {
            byte[] arrayOfByte = this.sendGET(this.mCameraAddress + "/camera/se" + "?t=" + this.getToken());
            return this.getCameraSettings(new GoProProtocolParser(arrayOfByte));
        }
        catch (Exception localException) {
            throw new Exception("Fail to get camera settings", localException);
        }
    }

    public CamFields getCameraSettings(GoProProtocolParser paramGoProProtocolParser) {
        CamFields localCamFields = new CamFields();
        if (paramGoProProtocolParser.extractResultCode() != GoProProtocolParser.RESULT_IS_OK) {
            return null;
        }
        localCamFields.setMode(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setMicrophoneMode(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setOndefault(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setExposure(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setTimeLapse(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setAutopower(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setFieldOfView(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setPhotoResolution(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setVidres(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setAudioinput(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setPlaymode(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setPlaybackPos(paramGoProProtocolParser.extractInteger());
        localCamFields.setBeepSound(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setLedblink(paramGoProProtocolParser.extractUnsignedByte());
        byte i = paramGoProProtocolParser.extractByte();
        localCamFields.setPreviewActive(true);
        localCamFields.setBattery(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setUsbMode(paramGoProProtocolParser.extractUnsignedByte());
        localCamFields.setPhotosAvailable(paramGoProProtocolParser.extractShort());
        localCamFields.setPhotosOncard(paramGoProProtocolParser.extractShort());
        localCamFields.setVideoAvailable(paramGoProProtocolParser.extractShort());
        localCamFields.setVideoOncard(paramGoProProtocolParser.extractShort());
        localCamFields.setShutter(paramGoProProtocolParser.extractUnsignedByte());
        return localCamFields;
    }

    public CamFields getCameraSettingsExtended() {
        CamFields localCamFields;
        GoProProtocolParser localGoProProtocolParser;
        try {
            byte[] arrayOfByte = this.sendGET(this.mCameraAddress + (Object)((Object)Operations.CAMERA_SX) + "?t=" + this.getToken());
            localGoProProtocolParser = new GoProProtocolParser(arrayOfByte);
            localCamFields = this.getCameraSettings(localGoProProtocolParser);
            if (localCamFields == null) {
                return localCamFields;
            }
        }
        catch (Exception localException) {
            return null;
        }
        HashMap<String, Number> localHashMap = new HashMap<String, Number>();
        localCamFields.setSettingsBag(localHashMap);
        localHashMap.put("camera/SS", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/BU", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/CS", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/WB", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/BR", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/PN", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/LO", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/PS", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/BX", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/TS", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("video_loop_counter", localGoProProtocolParser.extractInteger());
        localHashMap.put("external_battery", localGoProProtocolParser.extractUnsignedByte());
        byte i = localGoProProtocolParser.extractByte();
        localHashMap.put("bombie_attached", i & 8);
        localHashMap.put("lcd_attached", i & 4);
        localHashMap.put("is_boradcasting", i & 2);
        localHashMap.put("is_uploading", i & 1);
        localHashMap.put("camera/LV", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/LN", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/LS", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/VV", localGoProProtocolParser.extractUnsignedByte());
        localHashMap.put("camera/FS", localGoProProtocolParser.extractUnsignedByte());
        return localCamFields;
    }

    public DefaultHttpClient newInstance() {
        BasicHttpParams localBasicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)localBasicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)localBasicHttpParams, (String)"ISO-8859-1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)localBasicHttpParams, (boolean)true);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)localBasicHttpParams, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)localBasicHttpParams, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)localBasicHttpParams, (int)10000);
        HttpConnectionParams.setSocketBufferSize((HttpParams)localBasicHttpParams, (int)8192);
        SchemeRegistry localSchemeRegistry = new SchemeRegistry();
        localSchemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        ConnManagerParams.setMaxTotalConnections((HttpParams)localBasicHttpParams, (int)1);
        return new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager((HttpParams)localBasicHttpParams, localSchemeRegistry), (HttpParams)localBasicHttpParams);
    }

    public boolean sendCommand(Operations paramString, int paramInt) throws Exception {
        StringBuilder localStringBuilder = new StringBuilder("%");
        Object[] arrayOfObject = new Object[]{paramInt};
        return this.sendCommand(paramString, String.format("%02x", arrayOfObject));
    }

    public boolean sendCommand(Operations paramString1, String paramString2) throws Exception {
        String param = null;
        if (!paramString1.toString().startsWith("/")) {
            param = "/" + paramString1.toString();
        }
        this.sendGET(this.mCameraAddress + param + "?t=" + this.getToken() + "&p=" + paramString2);
        return true;
    }

    public byte[] sendGET(String paramString) throws Exception {
        return this.sendGET(paramString, this.mClient);
    }

    public byte[] sendGET(String paramString, DefaultHttpClient paramDefaultHttpClient) throws Exception {
        ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("Cmd :" + paramString);
        System.setProperty("http.keepAlive", "true");
        HttpGet localHttpGet = new HttpGet(paramString);
        HttpResponse localHttpResponse = paramDefaultHttpClient.execute((HttpUriRequest)localHttpGet);
        int statusCode = localHttpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 400) {
            localHttpGet.abort();
            throw new IOException("Fail to send GET - HTTP error code = [" + statusCode + "]");
        }
        int j = (int)localHttpResponse.getEntity().getContentLength();
        if (j <= 0) {
            j = 128;
        }
        InputStream localInputStream = localHttpResponse.getEntity().getContent();
        byte[] arrayOfByte = new byte[j];
        while (true) {
            if (localInputStream.read(arrayOfByte, 0, arrayOfByte.length) == -1) {
                localByteArrayOutputStream.flush();
                return localByteArrayOutputStream.toByteArray();
            }
            localByteArrayOutputStream.write(arrayOfByte, 0, arrayOfByte.length);
        }
    }

    public boolean setBacPacWifiMode(int paramInt) throws Exception {
        return this.sendCommand(Operations.BACPAC_WI, paramInt);
    }

    public boolean setBackPackPowerCamera(boolean paramBoolean) throws Exception {
        return this.sendCommand(Operations.BACPAC_PW, this.fromBoolean(paramBoolean));
    }

    public boolean setCamAutoPowerOff(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_AO, paramInt);
    }

    public boolean setCamDateTime(String paramString) {
        try {
            boolean bool = this.passFail(this.sendGET(this.mCameraAddress + "/camera/TM?t=" + this.getToken() + "&p=" + paramString));
            return bool;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setCamDefaultMode(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_DM, paramInt);
    }

    public boolean setCamExposure(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_EX, paramInt);
    }

    public boolean setCamFov(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_FV, paramInt);
    }

    public boolean setCamLEDBlink(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_LB, paramInt);
    }

    public boolean setCamLivePreview(boolean paramBoolean) throws Exception {
        if (paramBoolean) {
            // empty if block
        }
        int i = 2;
        return this.sendCommand(Operations.CAMERA_PV, i);
    }

    public boolean setCamLocate(boolean paramBoolean) throws Exception {
        return this.sendCommand(Operations.CAMERA_LL, this.fromBoolean(paramBoolean));
    }

    public boolean setCamMode(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_CM, paramInt);
    }

    public boolean setCamNtscPal(boolean paramBoolean) throws Exception {
        if (paramBoolean) {
            // empty if block
        }
        int i = 0;
        return this.sendCommand(Operations.CAMERA_VM, i);
    }

    public boolean setCamOnScreenDisplay(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_DS, paramInt);
    }

    public boolean setCamPhotoResolution(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_PR, paramInt);
    }

    public boolean setCamProtune(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_PT, paramInt);
    }

    public boolean setCamShutter(boolean paramBoolean) throws Exception {
        return this.sendCommand(Operations.BACPAC_SH, this.fromBoolean(paramBoolean));
    }

    public boolean setCamSound(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_BS, paramInt);
    }

    public boolean setCamTimeLapseTI(String paramString) throws Exception {
        return this.sendCommand(Operations.CAMERA_TI, paramString);
    }

    public boolean setCamUpDown(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_UP, paramInt);
    }

    public boolean setCamVideoResolution(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_VR, paramInt);
    }

    public boolean setCameraHLSSegment(int paramInt) throws Exception {
        return this.sendCommand(Operations.CAMERA_HS, paramInt);
    }

    public boolean setCameraName(String paramString) {
        if (paramString.length() > 31 || paramString.length() == 0) {
            return false;
        }
        Object[] arrayOfObject = new Object[]{paramString.length(), paramString};
        String str = URLEncoder.encode(String.format("%x%s", arrayOfObject).replaceAll("\\s+", "%20"));
        try {
            boolean bool = this.passFail(this.sendGET(this.mCameraAddress + (Object)((Object)Operations.CAMERA_CN) + "?t=" + this.getToken() + "&p=%0" + str));
            return bool;
        }
        catch (Exception localException) {
            return false;
        }
    }

    public boolean toBoolean(int paramInt) {
        return paramInt != 0;
    }

    public String getToken() {
        return this.getPassword();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    private void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    private Integer getPort() {
        return this.port;
    }

    private void setPort(Integer port) {
        this.port = port;
    }

    private String getPassword() {
        return this.password;
    }

    private void setPassword(String password) {
        this.password = password;
    }

    public boolean startRecord() throws Exception {
        return this.sendCommand(Operations.BACPAC_SH, "%01");
    }

    public boolean stopRecord() throws Exception {
        return this.sendCommand(Operations.BACPAC_SH, "%00");
    }

    public boolean turnOnCamera() throws Exception {
        return this.sendCommand(Operations.BACPAC_PW, "%01");
    }

    public boolean turnOffCamera() throws Exception {
        return this.sendCommand(Operations.BACPAC_PW, "%00");
    }

    public boolean changeModeCamera() throws Exception {
        return this.sendCommand(Operations.BACPAC_PW, "%02");
    }

    public boolean modeCamera() throws Exception {
        return this.sendCommand(Operations.CAMERA_CM, "%00");
    }

    public boolean modePhoto() throws Exception {
        return this.sendCommand(Operations.CAMERA_CM, "%01");
    }

    public boolean modeBurst() throws Exception {
        return this.sendCommand(Operations.CAMERA_CM, "%02");
    }
}

