/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.IAccountApi;
import io.api.etherscan.core.IBlockApi;
import io.api.etherscan.core.IContractApi;
import io.api.etherscan.core.ILogsApi;
import io.api.etherscan.core.IProxyApi;
import io.api.etherscan.core.IStatisticApi;
import io.api.etherscan.core.ITransactionApi;
import io.api.etherscan.core.impl.AccountApiProvider;
import io.api.etherscan.core.impl.BlockApiProvider;
import io.api.etherscan.core.impl.ContractApiProvider;
import io.api.etherscan.core.impl.LogsApiProvider;
import io.api.etherscan.core.impl.ProxyApiProvider;
import io.api.etherscan.core.impl.StatisticApiProvider;
import io.api.etherscan.core.impl.TransactionApiProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.error.ApiKeyException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.executor.impl.HttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.manager.impl.FakeQueueManager;
import io.api.etherscan.manager.impl.QueueManager;
import io.api.etherscan.model.EthNetwork;
import io.api.etherscan.util.BasicUtils;
import java.util.function.Supplier;

public class EtherScanApi {
    private static final Supplier<IHttpExecutor> DEFAULT_SUPPLIER = HttpExecutor::new;
    private final IAccountApi account;
    private final IBlockApi block;
    private final IContractApi contract;
    private final ILogsApi logs;
    private final IProxyApi proxy;
    private final IStatisticApi stats;
    private final ITransactionApi txs;

    public EtherScanApi() {
        this("YourApiKeyToken", EthNetwork.MAINNET);
    }

    public EtherScanApi(EthNetwork network) {
        this("YourApiKeyToken", network);
    }

    public EtherScanApi(String apiKey) {
        this(apiKey, EthNetwork.MAINNET);
    }

    public EtherScanApi(EthNetwork network, Supplier<IHttpExecutor> executorSupplier) {
        this("YourApiKeyToken", network, executorSupplier);
    }

    public EtherScanApi(String apiKey, EthNetwork network) {
        this(apiKey, network, DEFAULT_SUPPLIER);
    }

    public EtherScanApi(String apiKey, EthNetwork network, Supplier<IHttpExecutor> executorSupplier) {
        if (BasicUtils.isBlank(apiKey)) {
            throw new ApiKeyException("API key can not be null or empty");
        }
        if (network == null) {
            throw new ApiException("Ethereum Network is set to NULL value");
        }
        IQueueManager masterQueue = apiKey.equals("YourApiKeyToken") ? new FakeQueueManager() : new QueueManager(5, 1);
        IHttpExecutor executor = executorSupplier.get();
        String baseUrl = "https://" + network.getDomain() + ".etherscan.io/api?apikey=" + apiKey;
        this.account = new AccountApiProvider(masterQueue, baseUrl, executor);
        this.block = new BlockApiProvider(masterQueue, baseUrl, executor);
        this.contract = new ContractApiProvider(masterQueue, baseUrl, executor);
        this.logs = new LogsApiProvider(masterQueue, baseUrl, executor);
        this.proxy = new ProxyApiProvider(masterQueue, baseUrl, executor);
        this.stats = new StatisticApiProvider(masterQueue, baseUrl, executor);
        this.txs = new TransactionApiProvider(masterQueue, baseUrl, executor);
    }

    public IAccountApi account() {
        return this.account;
    }

    public IContractApi contract() {
        return this.contract;
    }

    public ITransactionApi txs() {
        return this.txs;
    }

    public IBlockApi block() {
        return this.block;
    }

    public ILogsApi logs() {
        return this.logs;
    }

    public IProxyApi proxy() {
        return this.proxy;
    }

    public IStatisticApi stats() {
        return this.stats;
    }
}

