/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model.proxy;

import io.api.etherscan.model.proxy.TxProxy;
import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;

public class BlockProxy {
    private String number;
    private Long _number;
    private String hash;
    private String parentHash;
    private String stateRoot;
    private String size;
    private Long _size;
    private String difficulty;
    private String totalDifficulty;
    private String timestamp;
    private LocalDateTime _timestamp;
    private String miner;
    private String nonce;
    private String extraData;
    private String logsBloom;
    private String mixHash;
    private String gasUsed;
    private BigInteger _gasUsed;
    private String gasLimit;
    private BigInteger _gasLimit;
    private String sha3Uncles;
    private List<String> uncles;
    private String receiptsRoot;
    private String transactionsRoot;
    private List<TxProxy> transactions;

    public Long getNumber() {
        if (this._number == null && !BasicUtils.isEmpty(this.number)) {
            this._number = BasicUtils.parseHex(this.number).longValue();
        }
        return this._number;
    }

    public String getHash() {
        return this.hash;
    }

    public String getParentHash() {
        return this.parentHash;
    }

    public String getStateRoot() {
        return this.stateRoot;
    }

    public Long getSize() {
        if (this._size == null && !BasicUtils.isEmpty(this.size)) {
            this._size = BasicUtils.parseHex(this.size).longValue();
        }
        return this._size;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public String getTotalDifficulty() {
        return this.totalDifficulty;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timestamp == null && !BasicUtils.isEmpty(this.timestamp)) {
            this._timestamp = LocalDateTime.ofEpochSecond(BasicUtils.parseHex(this.timestamp).longValue(), 0, ZoneOffset.UTC);
        }
        return this._timestamp;
    }

    public String getMiner() {
        return this.miner;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public String getMixHash() {
        return this.mixHash;
    }

    public BigInteger getGasUsed() {
        if (this._gasUsed == null && !BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = BasicUtils.parseHex(this.gasUsed);
        }
        return this._gasUsed;
    }

    public BigInteger getGasLimit() {
        if (this._gasLimit == null && !BasicUtils.isEmpty(this.gasLimit)) {
            this._gasLimit = BasicUtils.parseHex(this.gasLimit);
        }
        return this._gasLimit;
    }

    public String getSha3Uncles() {
        return this.sha3Uncles;
    }

    public List<String> getUncles() {
        return this.uncles;
    }

    public String getReceiptsRoot() {
        return this.receiptsRoot;
    }

    public String getTransactionsRoot() {
        return this.transactionsRoot;
    }

    public List<TxProxy> getTransactions() {
        return this.transactions;
    }
}

