/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class Block {
    private long blockNumber;
    private BigInteger blockReward;
    private String timeStamp;
    private LocalDateTime _timeStamp;

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            this._timeStamp = LocalDateTime.ofEpochSecond(Long.valueOf(this.timeStamp), 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public BigInteger getBlockReward() {
        return this.blockReward;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return this.blockNumber == block.blockNumber;
    }

    public int hashCode() {
        return (int)(this.blockNumber ^ this.blockNumber >>> 32);
    }

    public String toString() {
        return "Block{blockNumber=" + this.blockNumber + ", blockReward=" + this.blockReward + ", timeStamp='" + this.timeStamp + '\'' + ", _timeStamp=" + this._timeStamp + '}';
    }
}

