/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;

public class Log {
    private String blockNumber;
    private Long _blockNumber;
    private String address;
    private String transactionHash;
    private String transactionIndex;
    private Long _transactionIndex;
    private String timeStamp;
    private LocalDateTime _timeStamp;
    private String data;
    private String gasPrice;
    private BigInteger _gasPrice;
    private String gasUsed;
    private BigInteger _gasUsed;
    private List<String> topics;
    private String logIndex;
    private Long _logIndex;

    public Long getBlockNumber() {
        if (this._blockNumber == null && !BasicUtils.isEmpty(this.blockNumber)) {
            this._blockNumber = BasicUtils.parseHex(this.blockNumber).longValue();
        }
        return this._blockNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public Long getTransactionIndex() {
        if (this._transactionIndex == null && !BasicUtils.isEmpty(this.transactionIndex)) {
            this._transactionIndex = BasicUtils.parseHex(this.transactionIndex).longValue();
        }
        return this._transactionIndex;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            long formatted = this.timeStamp.charAt(0) == '0' && this.timeStamp.charAt(1) == 'x' ? BasicUtils.parseHex(this.timeStamp).longValue() : Long.valueOf(this.timeStamp).longValue();
            this._timeStamp = LocalDateTime.ofEpochSecond(formatted, 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public String getData() {
        return this.data;
    }

    public BigInteger getGasPrice() {
        if (!BasicUtils.isEmpty(this.gasPrice)) {
            this._gasPrice = BasicUtils.parseHex(this.gasPrice);
        }
        return this._gasPrice;
    }

    public BigInteger getGasUsed() {
        if (!BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = BasicUtils.parseHex(this.gasUsed);
        }
        return this._gasUsed;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public Long getLogIndex() {
        if (this._logIndex == null && !BasicUtils.isEmpty(this.logIndex)) {
            this._logIndex = BasicUtils.parseHex(this.logIndex).longValue();
        }
        return this._logIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log log = (Log)o;
        if (this.blockNumber != null ? !this.blockNumber.equals(log.blockNumber) : log.blockNumber != null) {
            return false;
        }
        if (this._blockNumber != null ? !this._blockNumber.equals(log._blockNumber) : log._blockNumber != null) {
            return false;
        }
        if (this.address != null ? !this.address.equals(log.address) : log.address != null) {
            return false;
        }
        if (this.transactionHash != null ? !this.transactionHash.equals(log.transactionHash) : log.transactionHash != null) {
            return false;
        }
        if (this.transactionIndex != null ? !this.transactionIndex.equals(log.transactionIndex) : log.transactionIndex != null) {
            return false;
        }
        if (this._transactionIndex != null ? !this._transactionIndex.equals(log._transactionIndex) : log._transactionIndex != null) {
            return false;
        }
        if (this.timeStamp != null ? !this.timeStamp.equals(log.timeStamp) : log.timeStamp != null) {
            return false;
        }
        if (this._timeStamp != null ? !this._timeStamp.equals(log._timeStamp) : log._timeStamp != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(log.data) : log.data != null) {
            return false;
        }
        if (this.gasPrice != null ? !this.gasPrice.equals(log.gasPrice) : log.gasPrice != null) {
            return false;
        }
        if (this._gasPrice != null ? !this._gasPrice.equals(log._gasPrice) : log._gasPrice != null) {
            return false;
        }
        if (this.gasUsed != null ? !this.gasUsed.equals(log.gasUsed) : log.gasUsed != null) {
            return false;
        }
        if (this._gasUsed != null ? !this._gasUsed.equals(log._gasUsed) : log._gasUsed != null) {
            return false;
        }
        if (this.topics != null ? !this.topics.equals(log.topics) : log.topics != null) {
            return false;
        }
        if (this.logIndex != null ? !this.logIndex.equals(log.logIndex) : log.logIndex != null) {
            return false;
        }
        return this._logIndex != null ? this._logIndex.equals(log._logIndex) : log._logIndex == null;
    }

    public int hashCode() {
        int result = this.blockNumber != null ? this.blockNumber.hashCode() : 0;
        result = 31 * result + (this._blockNumber != null ? this._blockNumber.hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.transactionHash != null ? this.transactionHash.hashCode() : 0);
        result = 31 * result + (this.transactionIndex != null ? this.transactionIndex.hashCode() : 0);
        result = 31 * result + (this._transactionIndex != null ? this._transactionIndex.hashCode() : 0);
        result = 31 * result + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        result = 31 * result + (this._timeStamp != null ? this._timeStamp.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.gasPrice != null ? this.gasPrice.hashCode() : 0);
        result = 31 * result + (this._gasPrice != null ? this._gasPrice.hashCode() : 0);
        result = 31 * result + (this.gasUsed != null ? this.gasUsed.hashCode() : 0);
        result = 31 * result + (this._gasUsed != null ? this._gasUsed.hashCode() : 0);
        result = 31 * result + (this.topics != null ? this.topics.hashCode() : 0);
        result = 31 * result + (this.logIndex != null ? this.logIndex.hashCode() : 0);
        result = 31 * result + (this._logIndex != null ? this._logIndex.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Log{blockNumber='" + this.blockNumber + '\'' + ", _blockNumber=" + this._blockNumber + ", address='" + this.address + '\'' + ", transactionHash='" + this.transactionHash + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", _transactionIndex=" + this._transactionIndex + ", timeStamp='" + this.timeStamp + '\'' + ", _timeStamp=" + this._timeStamp + ", data='" + this.data + '\'' + ", gasPrice='" + this.gasPrice + '\'' + ", _gasPrice=" + this._gasPrice + ", gasUsed='" + this.gasUsed + '\'' + ", _gasUsed=" + this._gasUsed + ", topics=" + this.topics + ", logIndex='" + this.logIndex + '\'' + ", _logIndex=" + this._logIndex + '}';
    }
}

