/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import com.google.gson.Gson;
import io.api.etherscan.error.EtherScanException;
import io.api.etherscan.error.ParseException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.util.BasicUtils;

abstract class BasicProvider {
    static final int MAX_END_BLOCK = 999999999;
    static final int MIN_START_BLOCK = 0;
    static final String ACT_PREFIX = "&action=";
    private final String module;
    private final String baseUrl;
    private final IHttpExecutor executor;
    private final IQueueManager queue;
    private final Gson gson;

    BasicProvider(IQueueManager queue, String module, String baseUrl, IHttpExecutor executor) {
        this.queue = queue;
        this.module = "&module=" + module;
        this.baseUrl = baseUrl;
        this.executor = executor;
        this.gson = new Gson();
    }

    <T> T convert(String json, Class<T> tClass) {
        try {
            return (T)this.gson.fromJson(json, tClass);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), e.getCause());
        }
    }

    String getRequest(String urlParameters) {
        this.queue.takeTurn();
        String url = this.baseUrl + this.module + urlParameters;
        String result = this.executor.get(url);
        if (BasicUtils.isEmpty(result)) {
            throw new EtherScanException("Server returned null value for GET request at URL - " + url);
        }
        return result;
    }

    String postRequest(String urlParameters, String dataToPost) {
        this.queue.takeTurn();
        String url = this.baseUrl + this.module + urlParameters;
        return this.executor.post(url, dataToPost);
    }

    <T> T getRequest(String urlParameters, Class<T> tClass) {
        return this.convert(this.getRequest(urlParameters), tClass);
    }

    <T> T postRequest(String urlParameters, String dataToPost, Class<T> tClass) {
        return this.convert(this.postRequest(urlParameters, dataToPost), tClass);
    }
}

