/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.manager.impl;

import io.api.etherscan.manager.IQueueManager;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class QueueManager
implements IQueueManager {
    private static final Logger logger = Logger.getLogger(QueueManager.class.getName());
    private final int queueSize;
    private final BlockingQueue<Integer> queue;
    private final List<Integer> queueValues;
    private final ScheduledExecutorService queueExecutor;

    public QueueManager(int queueSize, int queueResetTimeInSec) {
        this(queueSize, queueResetTimeInSec, 0);
    }

    public QueueManager(int queueSize, int queueResetTimeInSec, int delayInSec) {
        this.queueSize = queueSize;
        this.queueValues = this.generateList(queueSize);
        this.queue = new ArrayBlockingQueue<Integer>(queueSize);
        this.queueExecutor = Executors.newSingleThreadScheduledExecutor();
        this.queueExecutor.scheduleAtFixedRate(this.createTask(), delayInSec, queueResetTimeInSec, TimeUnit.SECONDS);
    }

    @Override
    public boolean takeTurn() {
        try {
            this.queue.take();
            return true;
        }
        catch (InterruptedException e) {
            logger.warning(e.getLocalizedMessage());
            return false;
        }
    }

    private Runnable createTask() {
        return () -> {
            try {
                if (this.queue.size() == this.queueSize) {
                    return;
                }
                this.queue.clear();
                this.queue.addAll(this.queueValues);
            }
            catch (Exception e) {
                logger.warning(e.getLocalizedMessage());
            }
        };
    }

    private List<Integer> generateList(int size) {
        return IntStream.range(0, size).boxed().collect(Collectors.toList());
    }
}

