/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import java.math.BigInteger;

public class Wei {
    private BigInteger result;

    public Wei(BigInteger value) {
        this.result = value;
    }

    public BigInteger getValue() {
        return this.result;
    }

    public BigInteger asKwei() {
        return this.result.divide(BigInteger.valueOf(1000L));
    }

    public BigInteger asMwei() {
        return this.result.divide(BigInteger.valueOf(1000000L));
    }

    public BigInteger asGwei() {
        return this.result.divide(BigInteger.valueOf(1000000000L));
    }

    public BigInteger asEther() {
        return this.result.divide(BigInteger.valueOf(1000000000000000L));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wei wei = (Wei)o;
        return this.result != null ? this.result.equals(wei.result) : wei.result == null;
    }

    public int hashCode() {
        return this.result != null ? this.result.hashCode() : 0;
    }

    public String toString() {
        return "Wei{result=" + this.result + '}';
    }
}

