/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.ITransactionApi;
import io.api.etherscan.core.impl.BasicProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.Status;
import io.api.etherscan.model.utility.ReceiptStatusResponseTO;
import io.api.etherscan.model.utility.StatusResponseTO;
import io.api.etherscan.util.BasicUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class TransactionApiProvider
extends BasicProvider
implements ITransactionApi {
    private static final String ACT_EXEC_STATUS_PARAM = "&action=getstatus";
    private static final String ACT_RECEIPT_STATUS_PARAM = "&action=gettxreceiptstatus";
    private static final String TXHASH_PARAM = "&txhash=";

    TransactionApiProvider(IQueueManager queue, String baseUrl, IHttpExecutor executor) {
        super(queue, "transaction", baseUrl, executor);
    }

    @Override
    @NotNull
    public Optional<Status> execStatus(String txhash) throws ApiException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=getstatus&txhash=" + txhash;
        StatusResponseTO response = this.getRequest(urlParams, StatusResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<Boolean> receiptStatus(String txhash) throws ApiException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=gettxreceiptstatus&txhash=" + txhash;
        ReceiptStatusResponseTO response = this.getRequest(urlParams, ReceiptStatusResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return response.getResult() == null || BasicUtils.isEmpty(response.getResult().getStatus()) ? Optional.empty() : Optional.of(response.getResult().getStatus().contains("1"));
    }
}

