/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.executor.impl;

import io.api.etherscan.error.ApiTimeoutException;
import io.api.etherscan.error.ConnectionException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.util.BasicUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class HttpExecutor
implements IHttpExecutor {
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    private static final int CONNECT_TIMEOUT = 8000;
    private static final int READ_TIMEOUT = 0;
    private final Map<String, String> headers;
    private final int connectTimeout;
    private final int readTimeout;

    public HttpExecutor() {
        this(8000);
    }

    public HttpExecutor(int connectTimeout) {
        this(connectTimeout, 0);
    }

    public HttpExecutor(int connectTimeout, int readTimeout) {
        this(connectTimeout, readTimeout, DEFAULT_HEADERS);
    }

    public HttpExecutor(int connectTimeout, int readTimeout, Map<String, String> headers) {
        this.connectTimeout = Math.max(connectTimeout, 0);
        this.readTimeout = Math.max(readTimeout, 0);
        this.headers = headers;
    }

    private HttpURLConnection buildConnection(String urlAsString, String method) throws IOException {
        URL url = new URL(urlAsString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        this.headers.forEach(connection::setRequestProperty);
        return connection;
    }

    @Override
    public String get(String urlAsString) {
        try {
            HttpURLConnection connection = this.buildConnection(urlAsString, "GET");
            int status = connection.getResponseCode();
            if (status == 302 || status == 301) {
                return this.get(connection.getHeaderField("Location"));
            }
            if (status >= 400 && status < 500) {
                throw new ConnectionException("Protocol error: " + connection.getResponseMessage());
            }
            if (status >= 500) {
                throw new ConnectionException("Server error: " + connection.getResponseMessage());
            }
            String data = this.readData(connection);
            connection.disconnect();
            return data;
        }
        catch (SocketTimeoutException e) {
            throw new ApiTimeoutException("Timeout: Could not establish connection for " + this.connectTimeout + " millis", e);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), e);
        }
    }

    @Override
    public String post(String urlAsString, String dataToPost) {
        try {
            HttpURLConnection connection = this.buildConnection(urlAsString, "POST");
            String contentLength = BasicUtils.isBlank(dataToPost) ? "0" : String.valueOf(dataToPost.length());
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Content-Length", contentLength);
            connection.setFixedLengthStreamingMode(dataToPost.length());
            connection.setDoOutput(true);
            connection.connect();
            try (OutputStream os = connection.getOutputStream();){
                os.write(dataToPost.getBytes(StandardCharsets.UTF_8));
            }
            int status = connection.getResponseCode();
            if (status == 302 || status == 301) {
                return this.post(connection.getHeaderField("Location"), dataToPost);
            }
            if (status >= 400 && status < 500) {
                throw new ConnectionException("Protocol error: " + connection.getResponseMessage());
            }
            if (status >= 500) {
                throw new ConnectionException("Server error: " + connection.getResponseMessage());
            }
            String data = this.readData(connection);
            connection.disconnect();
            return data;
        }
        catch (SocketTimeoutException e) {
            throw new ApiTimeoutException("Timeout: Could not establish connection for " + this.connectTimeout + " millis", e);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), e);
        }
    }

    private String readData(HttpURLConnection connection) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader in = new BufferedReader(this.getStreamReader(connection));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
        }
        return content.toString();
    }

    private InputStreamReader getStreamReader(HttpURLConnection connection) throws IOException {
        switch (String.valueOf(connection.getContentEncoding())) {
            case "gzip": {
                return new InputStreamReader((InputStream)new GZIPInputStream(connection.getInputStream()), StandardCharsets.UTF_8);
            }
            case "deflate": {
                return new InputStreamReader((InputStream)new InflaterInputStream(connection.getInputStream()), StandardCharsets.UTF_8);
            }
        }
        return new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
    }

    static {
        DEFAULT_HEADERS.put("Accept-Language", "en");
        DEFAULT_HEADERS.put("Accept-Encoding", "deflate, gzip");
        DEFAULT_HEADERS.put("User-Agent", "Chrome/68.0.3440.106");
        DEFAULT_HEADERS.put("Accept-Charset", "UTF-8");
    }
}

