/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.AccountAPI;
import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.Balance;
import io.goodforgod.api.etherscan.model.Block;
import io.goodforgod.api.etherscan.model.TokenBalance;
import io.goodforgod.api.etherscan.model.Tx;
import io.goodforgod.api.etherscan.model.TxErc1155;
import io.goodforgod.api.etherscan.model.TxErc20;
import io.goodforgod.api.etherscan.model.TxErc721;
import io.goodforgod.api.etherscan.model.TxInternal;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.model.response.BalanceResponseTO;
import io.goodforgod.api.etherscan.model.response.BaseListResponseTO;
import io.goodforgod.api.etherscan.model.response.BlockParam;
import io.goodforgod.api.etherscan.model.response.BlockResponseTO;
import io.goodforgod.api.etherscan.model.response.StringResponseTO;
import io.goodforgod.api.etherscan.model.response.TxErc1155ResponseTO;
import io.goodforgod.api.etherscan.model.response.TxErc20ResponseTO;
import io.goodforgod.api.etherscan.model.response.TxErc721ResponseTO;
import io.goodforgod.api.etherscan.model.response.TxInternalResponseTO;
import io.goodforgod.api.etherscan.model.response.TxResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class AccountAPIProvider
extends BasicProvider
implements AccountAPI {
    private static final int OFFSET_MAX = 10000;
    private static final String ACT_BALANCE_ACTION = "&action=balance";
    private static final String ACT_TOKEN_BALANCE_PARAM = "&action=tokenbalance";
    private static final String ACT_BALANCE_MULTI_ACTION = "&action=balancemulti";
    private static final String ACT_TX_ACTION = "&action=txlist";
    private static final String ACT_TX_INTERNAL_ACTION = "&action=txlistinternal";
    private static final String ACT_TX_ERC20_ACTION = "&action=tokentx";
    private static final String ACT_TX_ERC721_ACTION = "&action=tokennfttx";
    private static final String ACT_TX_ERC1155_ACTION = "&action=token1155tx";
    private static final String ACT_MINED_ACTION = "&action=getminedblocks";
    private static final String BLOCK_TYPE_PARAM = "&blocktype=blocks";
    private static final String CONTRACT_PARAM = "&contractaddress=";
    private static final String START_BLOCK_PARAM = "&startblock=";
    private static final String TAG_LATEST_PARAM = "&tag=latest";
    private static final String END_BLOCK_PARAM = "&endblock=";
    private static final String SORT_DESC_PARAM = "&sort=desc";
    private static final String SORT_ASC_PARAM = "&sort=asc";
    private static final String ADDRESS_PARAM = "&address=";
    private static final String TXHASH_PARAM = "&txhash=";
    private static final String OFFSET_PARAM = "&offset=";
    private static final String PAGE_PARAM = "&page=";

    AccountAPIProvider(RequestQueueManager requestQueueManager, String baseUrl, EthHttpClient executor, Converter converter) {
        super(requestQueueManager, "account", baseUrl, executor, converter);
    }

    @Override
    @NotNull
    public Balance balance(@NotNull String address) throws EtherScanException {
        BasicUtils.validateAddress(address);
        String urlParams = "&action=balance&tag=latest&address=" + address;
        StringResponseTO response = this.getRequest(urlParams, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return new Balance(address, Wei.ofWei(new BigInteger(response.getResult())));
    }

    @Override
    @NotNull
    public TokenBalance balance(@NotNull String address, @NotNull String contract) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BasicUtils.validateAddress(contract);
        String urlParams = "&action=tokenbalance&address=" + address + CONTRACT_PARAM + contract;
        StringResponseTO response = this.getRequest(urlParams, StringResponseTO.class);
        if (response.getStatus() != 1) {
            throw new EtherScanResponseException(response);
        }
        return new TokenBalance(address, Wei.ofWei(new BigInteger(response.getResult())), contract);
    }

    @Override
    @NotNull
    public List<Balance> balances(@NotNull List<String> addresses) throws EtherScanException {
        if (BasicUtils.isEmpty(addresses)) {
            return Collections.emptyList();
        }
        BasicUtils.validateAddresses(addresses);
        ArrayList<Balance> balances = new ArrayList<Balance>();
        List<List<String>> addressesAsBatches = BasicUtils.partition(addresses, 20);
        for (List<String> batch : addressesAsBatches) {
            String urlParams = "&action=balancemulti&tag=latest&address=" + this.toAddressParam(batch);
            BalanceResponseTO response = this.getRequest(urlParams, BalanceResponseTO.class);
            if (response.getStatus() != 1) {
                throw new EtherScanResponseException(response);
            }
            if (BasicUtils.isEmpty(response.getResult())) continue;
            balances.addAll(response.getResult().stream().map(r -> new Balance(r.getAccount(), Wei.ofWei(new BigInteger(r.getBalance())))).collect(Collectors.toList()));
        }
        return balances;
    }

    private String toAddressParam(List<String> addresses) {
        return String.join((CharSequence)",", addresses);
    }

    @Override
    @NotNull
    public List<Tx> txs(@NotNull String address) throws EtherScanException {
        return this.txs(address, 0L);
    }

    @Override
    @NotNull
    public List<Tx> txs(@NotNull String address, long startBlock) throws EtherScanException {
        return this.txs(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<Tx> txs(@NotNull String address, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String urlParams = "&action=txlist&page=%s&offset=10000&address=" + address + START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end() + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxResponseTO.class);
    }

    private <T, R extends BaseListResponseTO<T>> List<T> getRequestUsingOffset(String urlParams, Class<R> tClass) throws EtherScanException {
        BaseListResponseTO response;
        ArrayList result = new ArrayList();
        int page = 1;
        do {
            String formattedUrl = String.format(urlParams, page++);
            response = (BaseListResponseTO)this.getRequest(formattedUrl, tClass);
            BasicUtils.validateTxResponse(response);
            if (BasicUtils.isEmpty(response.getResult())) break;
            result.addAll(response.getResult());
        } while (response.getResult().size() >= 10000);
        return result;
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternal(@NotNull String address) throws EtherScanException {
        return this.txsInternal(address, 0L);
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternal(@NotNull String address, long startBlock) throws EtherScanException {
        return this.txsInternal(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternal(@NotNull String address, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String urlParams = "&action=txlistinternal&page=%s&offset=10000&address=" + address + START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end() + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxInternalResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxInternal> txsInternalByHash(@NotNull String txhash) throws EtherScanException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=txlistinternal&txhash=" + txhash;
        TxInternalResponseTO response = this.getRequest(urlParams, TxInternalResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return BasicUtils.isEmpty(response.getResult()) ? Collections.emptyList() : response.getResult();
    }

    @Override
    @NotNull
    public List<TxErc20> txsErc20(@NotNull String address) throws EtherScanException {
        return this.txsErc20(address, 0L);
    }

    @Override
    @NotNull
    public List<TxErc20> txsErc20(@NotNull String address, long startBlock) throws EtherScanException {
        return this.txsErc20(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxErc20> txsErc20(@NotNull String address, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String urlParams = "&action=tokentx&page=%s&offset=10000&address=" + address + START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end() + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxErc20ResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxErc20> txsErc20(@NotNull String address, @NotNull String contractAddress) throws EtherScanException {
        return this.txsErc20(address, contractAddress, 0L);
    }

    @Override
    @NotNull
    public List<TxErc20> txsErc20(@NotNull String address, @NotNull String contractAddress, long startBlock) throws EtherScanException {
        return this.txsErc20(address, contractAddress, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxErc20> txsErc20(@NotNull String address, @NotNull String contractAddress, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String offsetParam = "&page=%s&offset=10000";
        String blockParam = START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end();
        String urlParams = "&action=tokentx&page=%s&offset=10000&address=" + address + CONTRACT_PARAM + contractAddress + blockParam + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxErc20ResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxErc721> txsErc721(@NotNull String address) throws EtherScanException {
        return this.txsErc721(address, 0L);
    }

    @Override
    @NotNull
    public List<TxErc721> txsErc721(@NotNull String address, long startBlock) throws EtherScanException {
        return this.txsErc721(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxErc721> txsErc721(@NotNull String address, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String urlParams = "&action=tokennfttx&page=%s&offset=10000&address=" + address + START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end() + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxErc721ResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxErc721> txsErc721(@NotNull String address, @NotNull String contractAddress, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String offsetParam = "&page=%s&offset=10000";
        String blockParam = START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end();
        String urlParams = "&action=tokennfttx&page=%s&offset=10000&address=" + address + CONTRACT_PARAM + contractAddress + blockParam + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxErc721ResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxErc721> txsErc721(@NotNull String address, @NotNull String contractAddress, long startBlock) throws EtherScanException {
        return this.txsErc721(address, contractAddress, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxErc721> txsErc721(@NotNull String address, @NotNull String contractAddress) throws EtherScanException {
        return this.txsErc721(address, contractAddress, 0L);
    }

    @Override
    @NotNull
    public List<TxErc1155> txsErc1155(@NotNull String address, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String urlParams = "&action=token1155tx&page=%s&offset=10000&address=" + address + START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end() + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxErc1155ResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxErc1155> txsErc1155(@NotNull String address, long startBlock) throws EtherScanException {
        return this.txsErc1155(address, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxErc1155> txsErc1155(@NotNull String address) throws EtherScanException {
        return this.txsErc1155(address, 0L);
    }

    @Override
    @NotNull
    public List<TxErc1155> txsErc1155(@NotNull String address, @NotNull String contractAddress, long startBlock, long endBlock) throws EtherScanException {
        BasicUtils.validateAddress(address);
        BlockParam blocks = BasicUtils.compensateBlocks(startBlock, endBlock);
        String offsetParam = "&page=%s&offset=10000";
        String blockParam = START_BLOCK_PARAM + blocks.start() + END_BLOCK_PARAM + blocks.end();
        String urlParams = "&action=token1155tx&page=%s&offset=10000&address=" + address + CONTRACT_PARAM + contractAddress + blockParam + SORT_ASC_PARAM;
        return this.getRequestUsingOffset(urlParams, TxErc1155ResponseTO.class);
    }

    @Override
    @NotNull
    public List<TxErc1155> txsErc1155(@NotNull String address, @NotNull String contractAddress, long startBlock) throws EtherScanException {
        return this.txsErc1155(address, contractAddress, startBlock, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public List<TxErc1155> txsErc1155(@NotNull String address, @NotNull String contractAddress) throws EtherScanException {
        return this.txsErc1155(address, contractAddress, 0L);
    }

    @Override
    @NotNull
    public List<Block> blocksMined(@NotNull String address) throws EtherScanException {
        BasicUtils.validateAddress(address);
        String urlParams = "&action=getminedblocks&page=%s&offset=10000&blocktype=blocks&address=" + address;
        return this.getRequestUsingOffset(urlParams, BlockResponseTO.class);
    }
}

