/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.ContractAPI;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.Abi;
import io.goodforgod.api.etherscan.model.response.StringResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import org.jetbrains.annotations.NotNull;

final class ContractAPIProvider
extends BasicProvider
implements ContractAPI {
    private static final String ACT_ABI_PARAM = "&action=getabi";
    private static final String ADDRESS_PARAM = "&address=";

    ContractAPIProvider(RequestQueueManager requestQueueManager, String baseUrl, EthHttpClient executor, Converter converter) {
        super(requestQueueManager, "contract", baseUrl, executor, converter);
    }

    @Override
    @NotNull
    public Abi contractAbi(@NotNull String address) throws EtherScanException {
        BasicUtils.validateAddress(address);
        String urlParam = "&action=getabi&address=" + address;
        StringResponseTO response = this.getRequest(urlParam, StringResponseTO.class);
        if (response.getStatus() != 1 && response.getMessage().startsWith("NOTOK")) {
            throw new EtherScanResponseException(response);
        }
        return response.getResult().startsWith("Contract sou") ? Abi.nonVerified() : Abi.verified(response.getResult());
    }
}

