/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.BlockAPI;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.BlockUncle;
import io.goodforgod.api.etherscan.model.response.UncleBlockResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

final class BlockAPIProvider
extends BasicProvider
implements BlockAPI {
    private static final String ACT_BLOCK_PARAM = "&action=getblockreward";
    private static final String BLOCKNO_PARAM = "&blockno=";

    BlockAPIProvider(RequestQueueManager requestQueueManager, String baseUrl, EthHttpClient executor, Converter converter, int retryCount) {
        super(requestQueueManager, "block", baseUrl, executor, converter, retryCount);
    }

    @Override
    @NotNull
    public Optional<BlockUncle> uncles(long blockNumber) throws EtherScanException {
        String urlParam = "&action=getblockreward&blockno=" + blockNumber;
        try {
            UncleBlockResponseTO responseTO = this.getRequest(urlParam, UncleBlockResponseTO.class);
            if (responseTO.getMessage().startsWith("NOTOK")) {
                return Optional.empty();
            }
            BasicUtils.validateTxResponse(responseTO);
            return responseTO.getResult() == null || responseTO.getResult().isEmpty() ? Optional.empty() : Optional.of(responseTO.getResult());
        }
        catch (EtherScanResponseException e) {
            if (e.getResponse().getMessage().startsWith("NOTOK")) {
                return Optional.empty();
            }
            throw e;
        }
    }
}

