/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.TransactionAPI;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.Status;
import io.goodforgod.api.etherscan.model.response.ReceiptStatusResponseTO;
import io.goodforgod.api.etherscan.model.response.StatusResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

final class TransactionAPIProvider
extends BasicProvider
implements TransactionAPI {
    private static final String ACT_EXEC_STATUS_PARAM = "&action=getstatus";
    private static final String ACT_RECEIPT_STATUS_PARAM = "&action=gettxreceiptstatus";
    private static final String TXHASH_PARAM = "&txhash=";

    TransactionAPIProvider(RequestQueueManager queue, String baseUrl, EthHttpClient executor, Converter converter, int retryCount) {
        super(queue, "transaction", baseUrl, executor, converter, retryCount);
    }

    @Override
    @NotNull
    public Optional<Status> statusExec(@NotNull String txhash) throws EtherScanException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=getstatus&txhash=" + txhash;
        StatusResponseTO response = this.getRequest(urlParams, StatusResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return Optional.ofNullable(response.getResult());
    }

    @Override
    @NotNull
    public Optional<Boolean> statusReceipt(@NotNull String txhash) throws EtherScanException {
        BasicUtils.validateTxHash(txhash);
        String urlParams = "&action=gettxreceiptstatus&txhash=" + txhash;
        ReceiptStatusResponseTO response = this.getRequest(urlParams, ReceiptStatusResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return response.getResult() == null || BasicUtils.isEmpty(response.getResult().getStatus()) ? Optional.empty() : Optional.of(response.getResult().getStatus().contains("1"));
    }
}

