/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import io.goodforgod.api.etherscan.model.Wei;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GasOracle {
    private Long LastBlock;
    private BigInteger SafeGasPrice;
    private BigInteger ProposeGasPrice;
    private BigInteger FastGasPrice;
    private BigDecimal suggestBaseFee;
    private String gasUsedRatio;

    protected GasOracle() {
    }

    public Long getLastBlock() {
        return this.LastBlock;
    }

    public Wei getSafeGasPriceInWei() {
        return Wei.ofGwei(this.SafeGasPrice);
    }

    public Wei getProposeGasPriceInWei() {
        return Wei.ofGwei(this.ProposeGasPrice);
    }

    public Wei getFastGasPriceInWei() {
        return Wei.ofGwei(this.FastGasPrice);
    }

    public BigDecimal getSuggestBaseFee() {
        return this.suggestBaseFee;
    }

    public List<BigDecimal> getGasUsedRatio() {
        return Arrays.stream(this.gasUsedRatio.split(",")).map(BigDecimal::new).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GasOracle)) {
            return false;
        }
        GasOracle gasOracle = (GasOracle)o;
        return Objects.equals(this.LastBlock, gasOracle.LastBlock) && Objects.equals(this.SafeGasPrice, gasOracle.SafeGasPrice) && Objects.equals(this.ProposeGasPrice, gasOracle.ProposeGasPrice) && Objects.equals(this.FastGasPrice, gasOracle.FastGasPrice) && Objects.equals(this.suggestBaseFee, gasOracle.suggestBaseFee) && Objects.equals(this.gasUsedRatio, gasOracle.gasUsedRatio);
    }

    public int hashCode() {
        return Objects.hash(this.LastBlock, this.SafeGasPrice, this.ProposeGasPrice, this.FastGasPrice, this.suggestBaseFee, this.gasUsedRatio);
    }

    public String toString() {
        return "GasOracle{LastBlock=" + this.LastBlock + ", SafeGasPrice=" + this.SafeGasPrice + ", ProposeGasPrice=" + this.ProposeGasPrice + ", FastGasPrice=" + this.FastGasPrice + ", suggestBaseFee=" + this.suggestBaseFee + ", gasUsedRatio=" + this.gasUsedRatio + '}';
    }

    public static GasOracleBuilder builder() {
        return new GasOracleBuilder();
    }

    public static final class GasOracleBuilder {
        private Long lastBlock;
        private Wei safeGasPrice;
        private Wei proposeGasPrice;
        private Wei fastGasPrice;
        private BigDecimal suggestBaseFee;
        private List<BigDecimal> gasUsedRatio;

        private GasOracleBuilder() {
        }

        public GasOracleBuilder withLastBlock(Long lastBlock) {
            this.lastBlock = lastBlock;
            return this;
        }

        public GasOracleBuilder withSafeGasPrice(Wei safeGasPrice) {
            this.safeGasPrice = safeGasPrice;
            return this;
        }

        public GasOracleBuilder withProposeGasPrice(Wei proposeGasPrice) {
            this.proposeGasPrice = proposeGasPrice;
            return this;
        }

        public GasOracleBuilder withFastGasPrice(Wei fastGasPrice) {
            this.fastGasPrice = fastGasPrice;
            return this;
        }

        public GasOracleBuilder withSuggestBaseFee(BigDecimal suggestBaseFee) {
            this.suggestBaseFee = suggestBaseFee;
            return this;
        }

        public GasOracleBuilder withGasUsedRatio(List<BigDecimal> gasUsedRatio) {
            this.gasUsedRatio = gasUsedRatio;
            return this;
        }

        public GasOracle build() {
            GasOracle gasOracle = new GasOracle();
            gasOracle.LastBlock = this.lastBlock;
            gasOracle.suggestBaseFee = this.suggestBaseFee;
            if (this.proposeGasPrice != null) {
                gasOracle.ProposeGasPrice = this.proposeGasPrice.asGwei().toBigInteger();
            }
            if (this.safeGasPrice != null) {
                gasOracle.SafeGasPrice = this.safeGasPrice.asGwei().toBigInteger();
            }
            if (this.fastGasPrice != null) {
                gasOracle.FastGasPrice = this.fastGasPrice.asGwei().toBigInteger();
            }
            if (this.gasUsedRatio != null) {
                gasOracle.gasUsedRatio = this.gasUsedRatio.stream().map(BigDecimal::toString).collect(Collectors.joining(","));
            }
            return gasOracle;
        }
    }
}

