/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan;

import io.goodforgod.api.etherscan.BasicProvider;
import io.goodforgod.api.etherscan.ContractAPI;
import io.goodforgod.api.etherscan.Converter;
import io.goodforgod.api.etherscan.error.EtherScanException;
import io.goodforgod.api.etherscan.error.EtherScanResponseException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.manager.RequestQueueManager;
import io.goodforgod.api.etherscan.model.Abi;
import io.goodforgod.api.etherscan.model.ContractCreation;
import io.goodforgod.api.etherscan.model.response.ContractCreationResponseTO;
import io.goodforgod.api.etherscan.model.response.StringResponseTO;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ContractAPIProvider
extends BasicProvider
implements ContractAPI {
    private static final String ACT_ABI_PARAM = "&action=getabi";
    private static final String ADDRESS_PARAM = "&address=";
    private static final String ACT_CONTRACT_CREATION_PARAM = "getcontractcreation";
    private static final String ACT_CONTRACT_CREATION = "&action=getcontractcreation";
    private static final String ACT_CONTRACT_ADDRESSES_PARAM = "&contractaddresses=";

    public ContractAPIProvider(RequestQueueManager requestQueueManager, String baseUrl, EthHttpClient executor, Converter converter, int retryCount) {
        super(requestQueueManager, "contract", baseUrl, executor, converter, retryCount);
    }

    @Override
    @NotNull
    public Abi contractAbi(@NotNull String address) throws EtherScanException {
        BasicUtils.validateAddress(address);
        String urlParam = "&action=getabi&address=" + address;
        StringResponseTO response = this.getResponse(urlParam, StringResponseTO.class);
        if (response.getStatus() != 1 && response.getMessage().startsWith("NOTOK")) {
            throw new EtherScanResponseException(response);
        }
        return response.getResult().startsWith("Contract sou") ? Abi.nonVerified() : Abi.verified(response.getResult());
    }

    @Override
    @NotNull
    public List<ContractCreation> contractCreation(@NotNull List<String> contractAddresses) throws EtherScanException {
        BasicUtils.validateAddresses(contractAddresses);
        String urlParam = "&action=getcontractcreation&contractaddresses=" + BasicUtils.toAddressParam(contractAddresses);
        ContractCreationResponseTO response = this.getResponse(urlParam, ContractCreationResponseTO.class);
        if (response.getStatus() != 1 && response.getMessage().startsWith("NOTOK")) {
            throw new EtherScanResponseException(response);
        }
        return response.getResult().stream().map(to -> ContractCreation.builder().withContractCreator(to.getContractCreator()).withContractAddress(to.getContractAddress()).withTxHash(to.getTxHash()).build()).collect(Collectors.toList());
    }
}

