/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.http.impl;

import io.goodforgod.api.etherscan.error.EtherScanConnectionException;
import io.goodforgod.api.etherscan.error.EtherScanConnectionTimeoutException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.http.EthResponse;
import io.goodforgod.api.etherscan.http.impl.UrlEthHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class JdkEthHttpClient
implements EthHttpClient {
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(8L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(2L);
    private final HttpClient httpClient;
    private final Duration requestTimeout;
    private final Map<String, String> headers;
    private final UrlEthHttpClient urlEthHttpClient;

    public JdkEthHttpClient() {
        this(HttpClient.newBuilder().connectTimeout(DEFAULT_CONNECT_TIMEOUT).followRedirects(HttpClient.Redirect.NORMAL).version(HttpClient.Version.HTTP_2).build(), DEFAULT_READ_TIMEOUT, DEFAULT_HEADERS);
    }

    public JdkEthHttpClient(HttpClient httpClient) {
        this(httpClient, DEFAULT_READ_TIMEOUT, DEFAULT_HEADERS);
    }

    public JdkEthHttpClient(HttpClient httpClient, Duration requestTimeout) {
        this(httpClient, requestTimeout, DEFAULT_HEADERS);
    }

    public JdkEthHttpClient(HttpClient httpClient, Duration requestTimeout, Map<String, String> headers) {
        this.httpClient = httpClient;
        this.requestTimeout = requestTimeout;
        this.headers = headers;
        this.urlEthHttpClient = new UrlEthHttpClient(DEFAULT_CONNECT_TIMEOUT, requestTimeout, headers);
    }

    @Override
    public EthResponse get(@NotNull URI uri) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().GET().uri(uri).timeout(this.requestTimeout);
        this.headers.forEach(requestBuilder::header);
        try {
            final HttpResponse<InputStream> response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            final byte[] bodyAsBytes = JdkEthHttpClient.getDeflatedBytes(response);
            return new EthResponse(){

                @Override
                public int statusCode() {
                    return response.statusCode();
                }

                @Override
                public byte[] body() {
                    return bodyAsBytes;
                }

                @Override
                @NotNull
                public Map<String, List<String>> headers() {
                    return response.headers().map();
                }
            };
        }
        catch (HttpConnectTimeoutException e) {
            throw new EtherScanConnectionTimeoutException("Connection Timeout: Could not establish connection to Etherscan server for " + String.valueOf(this.httpClient.connectTimeout().orElse(DEFAULT_CONNECT_TIMEOUT)) + " millis", e);
        }
        catch (IOException e) {
            throw new EtherScanConnectionException("Etherscan HTTP server network error occurred: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new EtherScanConnectionException("Etherscan HTTP server interrupt exception occurred: " + e.getMessage(), e);
        }
    }

    @Override
    public EthResponse post(@NotNull URI uri, byte[] body) {
        return this.urlEthHttpClient.post(uri, body);
    }

    private EthResponse postJdk(@NotNull URI uri, byte[] body) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(body)).uri(uri).timeout(this.requestTimeout);
        this.headers.forEach(requestBuilder::header);
        requestBuilder.header("Content-Type", "application/json; charset=UTF-8");
        try {
            final HttpResponse<InputStream> response = this.httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            final byte[] bodyAsBytes = JdkEthHttpClient.getDeflatedBytes(response);
            return new EthResponse(){

                @Override
                public int statusCode() {
                    return response.statusCode();
                }

                @Override
                public byte[] body() {
                    return bodyAsBytes;
                }

                @Override
                @NotNull
                public Map<String, List<String>> headers() {
                    return response.headers().map();
                }
            };
        }
        catch (HttpConnectTimeoutException e) {
            throw new EtherScanConnectionTimeoutException("Connection Timeout: Could not establish connection to Etherscan server for " + String.valueOf(this.httpClient.connectTimeout().orElse(DEFAULT_CONNECT_TIMEOUT)) + " millis", e);
        }
        catch (IOException e) {
            throw new EtherScanConnectionException("Etherscan HTTP server network error occurred: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new EtherScanConnectionException("Etherscan HTTP server interrupt exception occurred: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getDeflatedBytes(HttpResponse<InputStream> response) {
        try {
            Optional<String> encoding = response.headers().firstValue("content-encoding");
            if (encoding.isEmpty()) {
                try (InputStream is = response.body();){
                    byte[] byArray = is.readAllBytes();
                    return byArray;
                }
            }
            switch (encoding.get().strip().toLowerCase(Locale.ROOT)) {
                case "gzip": {
                    return new GZIPInputStream(response.body()).readAllBytes();
                }
                case "deflate": {
                    return new InflaterInputStream(response.body()).readAllBytes();
                }
            }
            try (InputStream is = response.body();){
                byte[] byArray = is.readAllBytes();
                return byArray;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        DEFAULT_HEADERS.put("Accept-Language", "en");
        DEFAULT_HEADERS.put("Accept-Encoding", "deflate, gzip");
        DEFAULT_HEADERS.put("User-Agent", "Chrome/68.0.3440.106");
        DEFAULT_HEADERS.put("Accept-Charset", "UTF-8");
    }
}

