/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.http.impl;

import io.goodforgod.api.etherscan.error.EtherScanConnectionException;
import io.goodforgod.api.etherscan.error.EtherScanConnectionTimeoutException;
import io.goodforgod.api.etherscan.http.EthHttpClient;
import io.goodforgod.api.etherscan.http.EthResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class UrlEthHttpClient
implements EthHttpClient {
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(8L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(2L);
    @Nullable
    private final Proxy proxy;
    private final Map<String, String> headers;
    private final int connectTimeout;
    private final int readTimeout;

    public UrlEthHttpClient() {
        this(DEFAULT_CONNECT_TIMEOUT);
    }

    public UrlEthHttpClient(Duration connectTimeout) {
        this(connectTimeout, DEFAULT_READ_TIMEOUT, DEFAULT_HEADERS, null);
    }

    public UrlEthHttpClient(Duration connectTimeout, Duration readTimeout) {
        this(connectTimeout, readTimeout, DEFAULT_HEADERS, null);
    }

    public UrlEthHttpClient(Duration connectTimeout, Duration readTimeout, Proxy proxy) {
        this(connectTimeout, readTimeout, DEFAULT_HEADERS, null);
    }

    public UrlEthHttpClient(Duration connectTimeout, Duration readTimeout, Map<String, String> headers) {
        this(connectTimeout, readTimeout, headers, null);
    }

    public UrlEthHttpClient(Duration connectTimeout, Duration readTimeout, Map<String, String> headers, @Nullable Proxy proxy) {
        this.connectTimeout = Math.toIntExact(connectTimeout.toMillis());
        this.readTimeout = Math.toIntExact(readTimeout.toMillis());
        this.headers = Collections.unmodifiableMap(headers);
        this.proxy = proxy;
    }

    private HttpURLConnection buildConnection(URI uri, String method) throws IOException {
        URL url = uri.toURL();
        HttpURLConnection connection = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
        connection.setRequestMethod(method);
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        this.headers.forEach(connection::setRequestProperty);
        return connection;
    }

    @Override
    public EthResponse get(@NotNull URI uri) {
        try {
            HttpURLConnection connection = this.buildConnection(uri, "GET");
            int status = connection.getResponseCode();
            if (status == 302 || status == 301) {
                return this.get(URI.create(connection.getHeaderField("Location")));
            }
            if (status >= 400 && status < 500) {
                throw new EtherScanConnectionException("Protocol error: " + connection.getResponseMessage());
            }
            if (status >= 500) {
                throw new EtherScanConnectionException("Server error: " + connection.getResponseMessage());
            }
            byte[] data = this.readData(connection);
            EthResponse ethResponse = EthResponse.of(connection.getResponseCode(), data, connection.getHeaderFields());
            connection.disconnect();
            return ethResponse;
        }
        catch (SocketTimeoutException e) {
            throw new EtherScanConnectionTimeoutException("Timeout: Could not establish connection for " + this.connectTimeout + " millis", e);
        }
        catch (Exception e) {
            throw new EtherScanConnectionException(e.getMessage(), e);
        }
    }

    @Override
    public EthResponse post(@NotNull URI uri, byte[] body) {
        try {
            HttpURLConnection connection = this.buildConnection(uri, "POST");
            int contentLength = body.length;
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
            connection.setFixedLengthStreamingMode(body.length);
            connection.setDoOutput(true);
            connection.connect();
            try (OutputStream os = connection.getOutputStream();){
                os.write(body);
            }
            int status = connection.getResponseCode();
            if (status == 302 || status == 301) {
                return this.post(URI.create(connection.getHeaderField("Location")), body);
            }
            if (status >= 400 && status < 500) {
                throw new EtherScanConnectionException("Protocol error: " + connection.getResponseMessage());
            }
            if (status >= 500) {
                throw new EtherScanConnectionException("Server error: " + connection.getResponseMessage());
            }
            byte[] data = this.readData(connection);
            EthResponse ethResponse = EthResponse.of(connection.getResponseCode(), data, connection.getHeaderFields());
            connection.disconnect();
            return ethResponse;
        }
        catch (SocketTimeoutException e) {
            throw new EtherScanConnectionTimeoutException("Timeout: Could not establish connection for " + this.connectTimeout + " millis", e);
        }
        catch (Exception e) {
            throw new EtherScanConnectionException(e.getMessage(), e);
        }
    }

    private byte[] readData(HttpURLConnection connection) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            try (InputStream in = this.getStreamReader(connection);){
                int nRead;
                byte[] data = new byte[256];
                while ((nRead = in.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private InputStream getStreamReader(HttpURLConnection connection) throws IOException {
        switch (String.valueOf(connection.getContentEncoding())) {
            case "gzip": {
                return new GZIPInputStream(connection.getInputStream());
            }
            case "deflate": {
                return new InflaterInputStream(connection.getInputStream());
            }
        }
        return connection.getInputStream();
    }

    static {
        DEFAULT_HEADERS.put("Accept-Language", "en");
        DEFAULT_HEADERS.put("Accept-Encoding", "deflate, gzip");
        DEFAULT_HEADERS.put("User-Agent", "Chrome/68.0.3440.106");
        DEFAULT_HEADERS.put("Accept-Charset", "UTF-8");
    }
}

