/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import com.google.gson.annotations.Expose;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTx
implements Comparable<BaseTx> {
    long blockNumber;
    String timeStamp;
    @Expose(deserialize=false, serialize=false)
    LocalDateTime _timeStamp;
    String hash;
    String from;
    String to;
    String contractAddress;
    String input;
    BigInteger gas;
    BigInteger gasUsed;

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            this._timeStamp = LocalDateTime.ofEpochSecond(Long.parseLong(this.timeStamp), 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public String getHash() {
        return this.hash;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getInput() {
        return this.input;
    }

    public Wei getGas() {
        return Wei.ofWei(this.gas);
    }

    public Wei getGasUsed() {
        return Wei.ofWei(this.gasUsed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTx)) {
            return false;
        }
        BaseTx baseTx = (BaseTx)o;
        return this.blockNumber == baseTx.blockNumber && Objects.equals(this.timeStamp, baseTx.timeStamp) && Objects.equals(this.hash, baseTx.hash) && Objects.equals(this.from, baseTx.from) && Objects.equals(this.to, baseTx.to) && Objects.equals(this.contractAddress, baseTx.contractAddress) && Objects.equals(this.input, baseTx.input) && Objects.equals(this.gas, baseTx.gas) && Objects.equals(this.gasUsed, baseTx.gasUsed);
    }

    public int hashCode() {
        return Objects.hash(this.blockNumber, this.timeStamp, this.hash, this.from, this.to, this.contractAddress, this.input, this.gas, this.gasUsed);
    }

    @Override
    public int compareTo(@NotNull BaseTx o) {
        return Long.compare(this.blockNumber, o.blockNumber);
    }
}

