/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import io.goodforgod.api.etherscan.model.BaseTx;
import io.goodforgod.api.etherscan.model.Tx;
import io.goodforgod.api.etherscan.model.TxErc1155;
import io.goodforgod.api.etherscan.model.TxErc20;
import io.goodforgod.api.etherscan.model.TxErc721;
import io.goodforgod.api.etherscan.model.Wei;
import java.math.BigInteger;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class BlockTx
extends BaseTx {
    long nonce;
    String blockHash;
    long transactionIndex;
    long confirmations;
    BigInteger gasPrice;
    BigInteger cumulativeGasUsed;

    public long getNonce() {
        return this.nonce;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public long getTransactionIndex() {
        return this.transactionIndex;
    }

    public Wei getGasPrice() {
        return Wei.ofWei(this.gasPrice);
    }

    public Wei getGasUsedCumulative() {
        return Wei.ofWei(this.cumulativeGasUsed);
    }

    public long getConfirmations() {
        return this.confirmations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockTx)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockTx blockTx = (BlockTx)o;
        return this.nonce == blockTx.nonce && this.transactionIndex == blockTx.transactionIndex && Objects.equals(this.blockHash, blockTx.blockHash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nonce, this.blockHash, this.transactionIndex);
    }

    @Override
    public int compareTo(@NotNull BaseTx o) {
        int superCompare = super.compareTo(o);
        if (superCompare == 0) {
            if (o instanceof Tx) {
                return Long.compare(this.transactionIndex, ((Tx)o).getTransactionIndex());
            }
            if (o instanceof TxErc20) {
                return Long.compare(this.transactionIndex, ((TxErc20)o).getTransactionIndex());
            }
            if (o instanceof TxErc721) {
                return Long.compare(this.transactionIndex, ((TxErc721)o).getTransactionIndex());
            }
            if (o instanceof TxErc1155) {
                return Long.compare(this.transactionIndex, ((TxErc1155)o).getTransactionIndex());
            }
        }
        return superCompare;
    }
}

