/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import java.util.Objects;

public class ContractCreation {
    private String contractAddress;
    private String contractCreator;
    private String txHash;

    protected ContractCreation() {
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getContractCreator() {
        return this.contractCreator;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractCreation that = (ContractCreation)o;
        return Objects.equals(this.contractAddress, that.contractAddress) && Objects.equals(this.contractCreator, that.contractCreator) && Objects.equals(this.txHash, that.txHash);
    }

    public int hashCode() {
        return Objects.hash(this.contractAddress, this.contractCreator, this.txHash);
    }

    public String toString() {
        return "ContractCreation{contractAddress=" + this.contractAddress + ", contractCreator=" + this.contractCreator + ", txHash=" + this.txHash + "}";
    }

    public static ContractCreationBuilder builder() {
        return new ContractCreationBuilder();
    }

    public static class ContractCreationBuilder {
        private String contractAddress;
        private String contractCreator;
        private String txHash;

        private ContractCreationBuilder() {
        }

        public ContractCreationBuilder withContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public ContractCreationBuilder withContractCreator(String contractCreator) {
            this.contractCreator = contractCreator;
            return this;
        }

        public ContractCreationBuilder withTxHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public ContractCreation build() {
            ContractCreation contractCreation = new ContractCreation();
            contractCreation.contractAddress = this.contractAddress;
            contractCreation.contractCreator = this.contractCreator;
            contractCreation.txHash = this.txHash;
            return contractCreation;
        }
    }
}

