/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.ftl;

import com.annotatedsql.ftl.AltNotify;
import com.annotatedsql.ftl.TriggerMeta;
import com.annotatedsql.util.TextUtils;
import com.annotatedsql.util.Where;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UriMeta {
    private final String path;
    private final int code;
    private final String tableLink;
    private final String codeHex;
    private final boolean isItem;
    private final String selectColumn;
    private final List<AltNotify> altNotify;
    private final boolean onlyQuery;
    private final List<TriggerMeta> triggers;
    private final boolean rawQuery;
    private final Where where;
    private final String customMimeType;

    public UriMeta(String path, int code, boolean isItem, String customMimeType, String selectColumn, String tableLink, String[] altNotify, boolean onlyQuery, List<TriggerMeta> triggers, boolean rawQuery, Where where) {
        this.path = path;
        this.code = code;
        this.tableLink = tableLink;
        this.isItem = isItem;
        this.selectColumn = selectColumn;
        this.onlyQuery = onlyQuery;
        this.triggers = triggers;
        this.rawQuery = rawQuery;
        this.where = where;
        this.codeHex = "0x" + Integer.toHexString(code);
        this.customMimeType = customMimeType;
        if (altNotify != null && altNotify.length != 0) {
            this.altNotify = new ArrayList<AltNotify>();
            for (String n : altNotify) {
                if (TextUtils.isEmpty(n)) continue;
                this.altNotify.add(new AltNotify(n));
            }
        } else {
            this.altNotify = Collections.emptyList();
        }
    }

    public String getPath() {
        return this.path;
    }

    public int getCode() {
        return this.code;
    }

    public String getTableLink() {
        return this.tableLink;
    }

    public String getCodeHex() {
        return this.codeHex;
    }

    public boolean isItem() {
        return this.isItem;
    }

    public String getSelectColumn() {
        return this.selectColumn;
    }

    public List<AltNotify> getAltNotify() {
        return this.altNotify;
    }

    public boolean isOnlyQuery() {
        return this.onlyQuery || this.rawQuery;
    }

    public List<TriggerMeta> getTriggers() {
        return this.triggers;
    }

    public boolean isTriggered() {
        return this.triggers != null && this.triggers.size() != 0;
    }

    public boolean isRawQuery() {
        return this.rawQuery;
    }

    public boolean isHasAltNotify() {
        return !this.altNotify.isEmpty();
    }

    public boolean isWhere() {
        return this.where != null && !this.where.isEmpty();
    }

    public String getQueryWhere() {
        assert (this.where != null);
        return this.where.getQueryWhere();
    }

    public String getWhereArgs() {
        assert (this.where != null);
        return this.where.getWhereArgs();
    }

    public String getCustomMimeType() {
        return this.customMimeType;
    }

    public boolean isHasCustomMimeType() {
        return !TextUtils.isEmpty(this.customMimeType);
    }
}

