/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.ftl;

import com.annotatedsql.ftl.ColumnMeta;
import com.annotatedsql.util.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class ViewMeta {
    private final String viewClassName;
    private final String viewName;
    private String sql;
    private final List<ViewTableInfo> tables = new ArrayList<ViewTableInfo>();

    public ViewMeta(String viewClassName, String viewName) {
        this.viewName = viewName;
        this.viewClassName = viewClassName;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void addTable(ViewTableInfo table, boolean toHead) {
        if (toHead && this.tables.size() > 0) {
            this.tables.add(0, table);
            return;
        }
        this.tables.add(table);
    }

    public List<ViewTableInfo> getTables() {
        return this.tables;
    }

    public String getViewClassName() {
        return this.viewClassName;
    }

    public boolean isHasSubTables() {
        return this.tables.size() != 0;
    }

    public static class ViewTableInfo {
        private final String tableName;
        private final String name;
        private final String className;
        private final List<ColumnMeta> columns;

        public ViewTableInfo(String name, String tableName, List<ColumnMeta> columns) {
            this.name = name;
            this.tableName = tableName;
            this.className = TextUtils.var2class(name);
            this.columns = columns;
        }

        public String getName() {
            return this.name;
        }

        public List<ColumnMeta> getColumns() {
            return this.columns;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

