/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor;

import com.annotatedsql.util.TextUtils;
import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class ProcessorLogger {
    public static final String ARG_LOG_LEVEL = "logLevel";
    private static final String LOG_TAG = "A_SQL: ";
    private static final LogLevel DEFAULT_LEVEL_VALUE = LogLevel.INFO;
    private Messager messager;
    private LogLevel logLevel = DEFAULT_LEVEL_VALUE;

    public ProcessorLogger(Messager messager, Map<String, String> options) {
        this.messager = messager;
        if (options != null && options.containsKey(ARG_LOG_LEVEL)) {
            String level = options.get(ARG_LOG_LEVEL);
            this.logLevel = LogLevel.parse(level);
        }
    }

    public void w(String msg) {
        this.w(msg, null);
    }

    public void w(String msg, Element element) {
        if (this.logLevel.ordinal() <= LogLevel.WARN.ordinal()) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, LOG_TAG + msg, element);
        }
    }

    public void i(String msg) {
        this.i(msg, null);
    }

    public void i(String msg, Element element) {
        if (this.logLevel.ordinal() == LogLevel.INFO.ordinal()) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, LOG_TAG + msg, element);
        }
    }

    public void e(String msg, Throwable e, Element element) {
        if (e != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, LOG_TAG + msg + ": " + e.getMessage(), element);
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, LOG_TAG + msg, element);
        }
    }

    public void e(String msg, Throwable e) {
        this.e(msg, e, null);
    }

    public void e(String msg, Element e) {
        this.e(msg, (Throwable)null, e);
    }

    public void e(String msg, Element ... elms) {
        if (elms != null && elms.length != 0) {
            for (Element e : elms) {
                this.e(msg, (Throwable)null, e);
            }
        } else {
            this.e(msg, (Throwable)null, (Element)null);
        }
    }

    public void e(String msg, Collection<? extends Element> elms) {
        if (elms != null && !elms.isEmpty()) {
            for (Element element : elms) {
                this.e(msg, (Throwable)null, element);
            }
        } else {
            this.e(msg, (Throwable)null, (Element)null);
        }
    }

    private static enum LogLevel {
        INFO,
        WARN,
        ERROR;


        public static LogLevel parse(String name) {
            if (TextUtils.isEmpty(name)) {
                return DEFAULT_LEVEL_VALUE;
            }
            for (LogLevel logLevel : LogLevel.values()) {
                if (!logLevel.name().equalsIgnoreCase(name)) continue;
                return logLevel;
            }
            return DEFAULT_LEVEL_VALUE;
        }
    }
}

