/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.provider;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.provider.Provider;
import com.annotatedsql.annotation.provider.Providers;
import com.annotatedsql.annotation.provider.Trigger;
import com.annotatedsql.annotation.provider.Triggers;
import com.annotatedsql.annotation.provider.URI;
import com.annotatedsql.annotation.sql.RawQuery;
import com.annotatedsql.annotation.sql.SimpleView;
import com.annotatedsql.annotation.sql.Table;
import com.annotatedsql.ftl.ProviderMeta;
import com.annotatedsql.ftl.TriggerMeta;
import com.annotatedsql.ftl.UriMeta;
import com.annotatedsql.processor.ProcessorLogger;
import com.annotatedsql.processor.sql.TableParser;
import com.annotatedsql.processor.sql.TableResult;
import com.annotatedsql.util.TextUtils;
import com.annotatedsql.util.Where;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.annotatedsql.annotation.provider.Provider", "com.annotatedsql.annotation.provider.Providers"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedOptions(value={"logLevel"})
public class ProviderProcessor
extends AbstractProcessor {
    private static final int MATCH_TYPE_ITEM = 1;
    private static final int MATCH_TYPE_DIR = 2;
    private static final int MATCH_TYPE_CUSTOM = 3;
    private int elementCode = 4096;
    private ProcessorLogger logger;
    private Configuration cfg = new Configuration();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger = new ProcessorLogger(processingEnv.getMessager(), processingEnv.getOptions());
        this.logger.i("[ProviderProcessor] init");
        this.cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/res"));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        try {
            return this.processProviders(roundEnv);
        }
        catch (AnnotationParsingException e) {
            this.logger.e(e.getMessage(), e.getElements());
            return false;
        }
    }

    private boolean processProviders(RoundEnvironment roundEnv) {
        Set<? extends Element> providersElements = roundEnv.getElementsAnnotatedWith(Providers.class);
        if (providersElements != null && !providersElements.isEmpty()) {
            if (providersElements.size() != 1) {
                this.logger.e("Please use one @Providers", providersElements);
                return false;
            }
            Element e = providersElements.iterator().next();
            Providers ps = e.getAnnotation(Providers.class);
            if (ps == null) {
                this.logger.e("ps is null", e);
                return false;
            }
            Provider[] providers = ps.value();
            if (providers == null || providers.length == 0) {
                this.logger.e("No one provider defined in @Providers", e);
                return false;
            }
            boolean b = true;
            for (Provider p : providers) {
                b &= this.processProvider(roundEnv, e, p);
            }
            return b;
        }
        Set<? extends Element> providerElements = roundEnv.getElementsAnnotatedWith(Provider.class);
        if (providerElements == null || providerElements.isEmpty()) {
            return false;
        }
        if (providerElements.size() != 1) {
            this.logger.e("Please use one provider file or @Providers for the same schema", providerElements);
            return false;
        }
        Element e = providerElements.iterator().next();
        return this.processProvider(roundEnv, e, null);
    }

    private boolean processProvider(RoundEnvironment roundEnv, Element e, Provider providerElement) {
        this.logger.i("processProvider start");
        if (e == null) {
            return false;
        }
        if (providerElement == null) {
            providerElement = e.getAnnotation(Provider.class);
        }
        if (TextUtils.isEmpty(providerElement.name())) {
            this.logger.e("Provider name can't be empty", e);
            return false;
        }
        ProviderMeta provider = new ProviderMeta(e.getSimpleName().toString(), providerElement.name());
        PackageElement pkg = (PackageElement)e.getEnclosingElement();
        provider.setPkgName(pkg.getQualifiedName().toString());
        provider.setSchemaClassName(providerElement.schemaClass());
        provider.setOpenHelperClass(providerElement.openHelperClass());
        provider.setAuthority(providerElement.authority());
        provider.setSupportTransaction(providerElement.supportTransaction());
        provider.setBulkInsertMode(providerElement.bulkInsertMode());
        provider.setInsertMode(providerElement.insertMode());
        this.processSchema(roundEnv, provider);
        this.logger.i("processProvider before generate: " + provider.getClassName());
        this.processTemplateForModel(provider);
        this.logger.i("processProvider end");
        return true;
    }

    private void processSchema(RoundEnvironment roundEnv, ProviderMeta provider) {
        List<UriMeta> uris;
        for (Element element : roundEnv.getElementsAnnotatedWith(Table.class)) {
            TableResult tableInfo;
            List<UriMeta> uris2;
            if (!(element instanceof TypeElement) || (uris2 = this.processTable(element, (tableInfo = new TableParser((TypeElement)element, new ParserEnv(null), this.logger).parse()).getWhere())) == null || uris2.isEmpty()) continue;
            provider.addImport(((TypeElement)element).getQualifiedName().toString());
            provider.addUris(uris2);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(SimpleView.class)) {
            uris = this.processTable(element, null);
            if (uris == null || uris.isEmpty()) continue;
            provider.addImport(((TypeElement)element).getQualifiedName().toString());
            provider.addUris(uris);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RawQuery.class)) {
            uris = this.processQuery(element);
            if (uris == null || uris.isEmpty()) continue;
            provider.addImport(((TypeElement)element).getQualifiedName().toString());
            provider.addUris(this.processQuery(element));
        }
    }

    private List<UriMeta> processQuery(Element element) {
        String parentName = element.getSimpleName().toString();
        RawQuery rawQuery = element.getAnnotation(RawQuery.class);
        String from = "SQL_QUERY_" + rawQuery.value().toUpperCase();
        return this.processUri(element, parentName, from, null, true);
    }

    private List<UriMeta> processTable(Element element, Where where) {
        String parentName = element.getSimpleName().toString();
        String nameField = this.findName(element);
        if (nameField == null) {
            throw new AnnotationParsingException("Can't find table/view name. Please define field TABLE_NAME or VIEW_NAME ", element);
        }
        String from = parentName + "." + nameField;
        return this.processUri(element, parentName, from, where, false);
    }

    private List<UriMeta> processUri(Element element, String parentName, String from, Where builder, boolean rawQuery) {
        ArrayList<UriMeta> uris = new ArrayList<UriMeta>();
        for (Element element2 : element.getEnclosedElements()) {
            URI uri = element2.getAnnotation(URI.class);
            if (uri == null) continue;
            ArrayList<TriggerMeta> triggersList = new ArrayList<TriggerMeta>();
            this.validateTrigger(element2, triggersList, element2.getAnnotation(Trigger.class));
            this.validateTrigger(element2, triggersList, element2.getAnnotation(Triggers.class));
            String pathValue = (String)((VariableElement)element2).getConstantValue();
            String path = parentName + "." + element2.getSimpleName().toString();
            if (uri.type() == URI.Type.DIR_AND_ITEM && !rawQuery) {
                uris.add(this.createUriMeta(URI.Type.DIR, uri.customMimeType(), path, uri.column(), pathValue, from, uri.altNotify(), uri.onlyQuery(), triggersList, builder, rawQuery));
                uris.add(this.createUriMeta(URI.Type.ITEM, uri.customMimeType(), path, uri.column(), pathValue, from, uri.altNotify(), uri.onlyQuery(), null, builder, rawQuery));
                continue;
            }
            uris.add(this.createUriMeta(uri.type(), uri.customMimeType(), path, uri.column(), pathValue, from, uri.altNotify(), uri.onlyQuery(), triggersList, builder, rawQuery));
        }
        return uris;
    }

    private void validateTrigger(Element e, List<TriggerMeta> triggersList, Triggers triggers) {
        if (triggers != null) {
            for (Trigger t : triggers.value()) {
                this.validateTrigger(e, triggersList, t);
            }
        }
    }

    private void validateTrigger(Element e, List<TriggerMeta> triggers, Trigger trigger) {
        if (trigger == null) {
            return;
        }
        String triggerMethod = trigger.name().trim();
        if (TextUtils.isEmpty(triggerMethod)) {
            throw new AnnotationParsingException("Trigger method name is empty", e);
        }
        triggers.add(new TriggerMeta(triggerMethod, trigger.type(), trigger.when() == Trigger.When.BEFORE));
    }

    private UriMeta createUriMeta(URI.Type type, String customMimeType, String path, String selectColumn, String pathValue, String from, String[] altNotify, boolean onlyQuery, List<TriggerMeta> triggers, Where builder, boolean rawQuery) {
        int typeMask;
        if (type == URI.Type.ITEM && !pathValue.endsWith("#")) {
            path = !pathValue.endsWith("/") ? path + " + \"/#\"" : path + " + \"#\"";
        }
        int n = typeMask = type == URI.Type.DIR ? 2 : 1;
        if (!TextUtils.isEmpty(customMimeType)) {
            typeMask = 3;
        }
        int code = this.elementCode | typeMask;
        this.elementCode += 16;
        return new UriMeta(path, code, type == URI.Type.ITEM, customMimeType, selectColumn, from, altNotify, onlyQuery, triggers, rawQuery, builder);
    }

    private String findName(Element element) {
        for (Element element2 : element.getEnclosedElements()) {
            String simpleName = element2.getSimpleName().toString();
            if (!"TABLE_NAME".equals(simpleName) && !"VIEW_NAME".equals(simpleName)) continue;
            return simpleName;
        }
        return null;
    }

    private void processTemplateForModel(ProviderMeta model) {
        try {
            String filePath = model.getPkgName() + "." + model.getClassName();
            this.logger.i("Creating file: " + filePath);
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(filePath, new Element[0]);
            this.logger.i("File created: " + filePath);
            Writer out = file.openWriter();
            Template t = this.cfg.getTemplate("provider.ftl");
            t.process((Object)model, out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.logger.e("EntityProcessor IOException: ", e);
        }
        catch (TemplateException e) {
            this.logger.e("EntityProcessor TemplateException: ", e);
        }
    }
}

