/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.sql;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.sql.RawQuery;
import com.annotatedsql.annotation.sql.Schema;
import com.annotatedsql.annotation.sql.SimpleView;
import com.annotatedsql.annotation.sql.Table;
import com.annotatedsql.ftl.IndexMeta;
import com.annotatedsql.ftl.SchemaMeta;
import com.annotatedsql.ftl.TableMeta;
import com.annotatedsql.ftl.ViewMeta;
import com.annotatedsql.processor.ProcessorLogger;
import com.annotatedsql.processor.sql.ISchemaPlugin;
import com.annotatedsql.processor.sql.RawQueryParser;
import com.annotatedsql.processor.sql.SimpleViewParser;
import com.annotatedsql.processor.sql.TableParser;
import com.annotatedsql.processor.sql.TableResult;
import com.annotatedsql.util.TextUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.annotatedsql.annotation.sql.Schema"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedOptions(value={"logLevel", "plugins"})
public class SQLProcessor
extends AbstractProcessor {
    public static final String ARG_PLUGINS = "plugins";
    private ProcessorLogger logger;
    private Configuration cfg = new Configuration();
    private List<ISchemaPlugin> plugins = new ArrayList<ISchemaPlugin>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger = new ProcessorLogger(processingEnv.getMessager(), processingEnv.getOptions());
        this.logger.i("[SQLProcessor] init");
        this.cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/res"));
        Map<String, String> options = processingEnv.getOptions();
        if (options != null) {
            this.logger.i("[SQLProcessor] init.options size = " + options.size());
            for (Map.Entry<String, String> e : options.entrySet()) {
                this.logger.i("[SQLProcessor] init.options " + e.getKey() + " = " + e.getValue());
            }
            if (options.containsKey(ARG_PLUGINS)) {
                this.registerPlugins(processingEnv, options.get(ARG_PLUGINS));
            }
        } else {
            this.logger.i("[SQLProcessor] init.options EMPTY");
        }
    }

    private void registerPlugins(ProcessingEnvironment processingEnv, String plugins) {
        String[] ar;
        if (TextUtils.isEmpty(plugins)) {
            return;
        }
        for (String s : ar = plugins.split(" ")) {
            try {
                Class<?> clazz = Class.forName(s);
                if (!ISchemaPlugin.class.isAssignableFrom(clazz)) {
                    this.logger.e("plugin " + s + " should extends ISchemaPlugin", new Element[0]);
                    continue;
                }
                this.logger.i("plugin " + s + " .newInstance");
                ISchemaPlugin plugin = (ISchemaPlugin)clazz.newInstance();
                this.logger.i("plugin " + s + " .newInstance end");
                plugin.init(processingEnv, this.logger);
                this.logger.i("plugin " + s + " .init end");
                this.plugins.add(plugin);
                this.logger.i("plugin " + s + " added");
            }
            catch (ClassNotFoundException e) {
                this.logger.e("Can't find plugin class: " + s, e);
            }
            catch (InstantiationException e) {
                this.logger.e("Can't instantiate plugin: " + s, e);
            }
            catch (IllegalAccessException e) {
                this.logger.e("Plugin should have open constructor: " + s, e);
            }
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.logger.i("SQLProcessor started");
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        try {
            return this.processTable(roundEnv);
        }
        catch (AnnotationParsingException e) {
            this.logger.e(e.getMessage(), e.getElements());
            return false;
        }
    }

    private boolean processTable(RoundEnvironment roundEnv) {
        TypeElement typeElement;
        Schema schema;
        TypeElement schemaElement;
        this.logger.i("SQLProcessor processTable");
        Set<? extends Element> schemaElements = roundEnv.getElementsAnnotatedWith(Schema.class);
        if (schemaElements != null && schemaElements.size() != 0) {
            if (schemaElements.size() != 1) {
                for (Element element : schemaElements) {
                    this.logger.e("Please use one schema file", element);
                }
                return false;
            }
            Element se = schemaElements.iterator().next();
            if (!(se instanceof TypeElement)) {
                this.logger.e("Schema should be interface or class", se);
                return false;
            }
            schemaElement = (TypeElement)se;
            schema = schemaElement.getAnnotation(Schema.class);
            if (TextUtils.isEmpty(schema.className())) {
                this.logger.e("Schema name can't be empty", (Element)schemaElement);
                return false;
            }
        } else {
            return false;
        }
        SchemaMeta schema2 = new SchemaMeta(schemaElement.getSimpleName().toString(), schema.className(), schemaElement.getSimpleName().toString());
        schema2.setDbName(schema.dbName());
        schema2.setDbVersion(schema.dbVersion());
        PackageElement packageElement = (PackageElement)schemaElement.getEnclosingElement();
        String pkgName = packageElement.getQualifiedName().toString();
        this.logger.i("SQLProcessor pkgName found: " + pkgName);
        schema2.setPkgName(pkgName);
        ParserEnv parserEnv = new ParserEnv(schema2.getStoreClassName());
        for (Element element : roundEnv.getElementsAnnotatedWith(Table.class)) {
            if (!(element instanceof TypeElement)) continue;
            this.logger.i("SQLProcessor table found: " + element.getSimpleName());
            typeElement = (TypeElement)element;
            TableResult tableInfo = new TableParser(typeElement, parserEnv, this.logger).parse();
            schema2.addTable(new TableMeta(tableInfo.getTableName(), tableInfo.getSql()));
            List<IndexMeta> indexes = TableParser.proceedIndexes(typeElement);
            if (indexes != null) {
                for (IndexMeta i : indexes) {
                    schema2.addIndex(i);
                }
            }
            this.processTableInPlugins(typeElement, tableInfo);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(SimpleView.class)) {
            if (!(element instanceof TypeElement)) continue;
            typeElement = (TypeElement)element;
            this.logger.i("SQLProcessor simple view found: " + element.getSimpleName());
            ViewMeta viewMeta = new SimpleViewParser(typeElement, parserEnv).parse();
            schema2.addView(viewMeta);
            this.processViewInPlugins(typeElement, viewMeta);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RawQuery.class)) {
            if (!(element instanceof TypeElement)) continue;
            typeElement = (TypeElement)element;
            this.logger.i("SQLProcessor raw query found: " + element.getSimpleName());
            ViewMeta rawMeta = new RawQueryParser(typeElement, parserEnv).parse();
            schema2.addQuery(rawMeta);
            this.processRawQueryInPlugins(typeElement, rawMeta);
        }
        if (schema2.isEmpty()) {
            return false;
        }
        this.processSchema(schema2);
        this.processSchemaExt(schema2);
        this.processSchemaInPlugins(schemaElement, schema2);
        return true;
    }

    private void processSchema(SchemaMeta model) {
        this.processTemplateForModel(model, "schema.ftl", null);
    }

    private void processSchemaExt(SchemaMeta model) {
        this.processTemplateForModel(model, "schema_extend.ftl", "2");
    }

    private void processTemplateForModel(SchemaMeta model, String templateName, String postfix) {
        try {
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(model.getPkgName() + "." + model.getClassName() + (postfix == null ? "" : postfix), new Element[0]);
            this.logger.i("Creating file:  " + model.getPkgName() + "." + file.getName());
            Writer out = file.openWriter();
            Template t = this.cfg.getTemplate(templateName);
            t.process((Object)model, out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.logger.e("EntityProcessor IOException: ", e);
        }
        catch (TemplateException e) {
            this.logger.e("EntityProcessor TemplateException: ", e);
        }
    }

    private void processSchemaInPlugins(TypeElement element, SchemaMeta model) {
        this.logger.i("processSchemaInPlugins");
        for (ISchemaPlugin plugin : this.plugins) {
            plugin.processSchema(element, model);
        }
        this.logger.i("processSchemaInPlugins end");
    }

    private void processTableInPlugins(TypeElement element, TableResult tableInfo) {
        this.logger.i("processTableInPlugins");
        for (ISchemaPlugin plugin : this.plugins) {
            plugin.processTable(element, tableInfo);
        }
        this.logger.i("processTableInPlugins end");
    }

    private void processViewInPlugins(TypeElement element, ViewMeta tableInfo) {
        this.logger.i("processViewInPlugins");
        for (ISchemaPlugin plugin : this.plugins) {
            plugin.processView(element, tableInfo);
        }
        this.logger.i("processViewInPlugins end");
    }

    private void processRawQueryInPlugins(TypeElement element, ViewMeta tableInfo) {
        for (ISchemaPlugin plugin : this.plugins) {
            plugin.processRawQuery(element, tableInfo);
        }
    }
}

