/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static List<Element> getAllClassFields(TypeElement c) {
        ArrayList<Element> fields = new ArrayList<Element>();
        ClassUtil.collectParentFields(fields, Arrays.asList(c.asType()));
        return fields;
    }

    public static void collectParentFields(List<Element> fields, List<? extends TypeMirror> typeMirrors) {
        if (typeMirrors == null || typeMirrors.isEmpty()) {
            return;
        }
        for (TypeMirror typeMirror : typeMirrors) {
            if (typeMirror instanceof NoType) continue;
            Element superClass = ((DeclaredType)typeMirror).asElement();
            List<? extends Element> inner = superClass.getEnclosedElements();
            if (inner != null) {
                fields.addAll(inner);
            }
            if (!(superClass instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)superClass;
            TypeMirror superclass = typeElement.getSuperclass();
            if (superclass != null) {
                ClassUtil.collectParentFields(fields, Arrays.asList(superclass));
            }
            ClassUtil.collectParentFields(fields, typeElement.getInterfaces());
        }
    }
}

