/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.util;

import com.annotatedsql.util.TextUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;

public class Where {
    private final List<WhereObject> where = new ArrayList<WhereObject>();
    private final List<WhereArgObject> whereArgs = new ArrayList<WhereArgObject>();
    private String alias;

    public Where(String alias) {
        this.alias = alias;
    }

    public Where copy(String newAlias) {
        Where copy = new Where(newAlias);
        copy.where.addAll(this.where);
        copy.whereArgs.addAll(this.whereArgs);
        return copy;
    }

    public Where add(String column, String value) {
        this.where.add(new WhereObject(column));
        this.whereArgs.add(new WhereArgObject(value));
        return this;
    }

    public String getQueryWhere() {
        assert (this.where != null);
        return Joiner.on((String)" and ").skipNulls().join(this.where);
    }

    public String getWhereArgs() {
        assert (this.whereArgs != null);
        return Joiner.on((String)", ").skipNulls().join(this.whereArgs);
    }

    public String getAsCondition() {
        StringBuffer condition = new StringBuffer(128);
        for (int i = 0; i < this.where.size(); ++i) {
            if (i != 0) {
                condition.append(" and ");
            }
            condition.append(this.alias).append('.').append(this.where.get(i).field).append(" = ").append(this.whereArgs.get(i).obj);
        }
        return condition.toString();
    }

    public boolean isEmpty() {
        return this.where.isEmpty();
    }

    public Where exclude(String excludeWhere) {
        if (TextUtils.isEmpty(excludeWhere)) {
            return this;
        }
        Where copyWhere = new Where(this.alias);
        for (int i = 0; i < this.where.size(); ++i) {
            WhereObject o = this.where.get(i);
            WhereArgObject arg = this.whereArgs.get(i);
            if (excludeWhere.equals(o.field)) continue;
            copyWhere.add(o.field, arg.obj);
        }
        return copyWhere;
    }

    private static class WhereArgObject {
        private final String obj;

        public WhereArgObject(String obj) {
            this.obj = obj;
        }

        public String toString() {
            return "\"" + this.obj + "\"";
        }
    }

    private class WhereObject {
        private final String field;

        public WhereObject(String field) {
            this.field = field;
        }

        public String toString() {
            return Where.this.alias + "." + this.field + " = ?";
        }
    }
}

