/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.sql;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.sql.From;
import com.annotatedsql.annotation.sql.Join;
import com.annotatedsql.annotation.sql.RawJoin;
import com.annotatedsql.annotation.sql.SimpleView;
import com.annotatedsql.ftl.ColumnMeta;
import com.annotatedsql.ftl.TableColumns;
import com.annotatedsql.ftl.ViewMeta;
import com.annotatedsql.processor.sql.view.FromParser;
import com.annotatedsql.processor.sql.view.FromResult;
import com.annotatedsql.processor.sql.view.JoinParser;
import com.annotatedsql.processor.sql.view.RawJoinParser;
import com.annotatedsql.util.Where;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;

public class SimpleViewParser {
    protected final HashMap<String, Element> aliases = new HashMap();
    protected final Element f;
    protected final ParserEnv parserEnv;
    protected ViewMeta viewMeta;
    protected StringBuilder select;
    protected StringBuilder sql;

    public SimpleViewParser(Element c, ParserEnv parserEnv) {
        this.f = c;
        this.parserEnv = parserEnv;
    }

    public ViewMeta parse() {
        SimpleView view = this.f.getAnnotation(SimpleView.class);
        String name = view.value();
        if (this.parserEnv.containsTable(name)) {
            throw new AnnotationParsingException(String.format("Table/View with name '%s' alredy defined", name), this.f);
        }
        this.viewMeta = new ViewMeta(this.f.getSimpleName().toString(), name);
        List<? extends Element> fields = this.f.getEnclosedElements();
        this.select = new StringBuilder(fields.size() * 32);
        this.sql = new StringBuilder(fields.size() * 32);
        this.sql.append("CREATE VIEW ").append(name).append(" AS SELECT ");
        int startSqlPos = this.sql.length();
        From from = null;
        FromResult fromResult = null;
        for (Element element : fields) {
            RawJoin rawJoin;
            From tmpFrom = element.getAnnotation(From.class);
            if (tmpFrom != null) {
                if (from != null) {
                    throw new AnnotationParsingException("Duplicate @From annotation", element);
                }
                fromResult = new FromParser(this.parserEnv, this, element).parse();
                this.handleFromResult(fromResult, true, startSqlPos);
                from = tmpFrom;
                continue;
            }
            Join join = element.getAnnotation(Join.class);
            if (join != null) {
                this.handleFromResult(new JoinParser(this.parserEnv, this, element).parse(), false, startSqlPos);
            }
            if ((rawJoin = element.getAnnotation(RawJoin.class)) == null) continue;
            if (join != null) {
                throw new AnnotationParsingException("element can have only one join", element);
            }
            this.handleFromResult(new RawJoinParser(this.parserEnv, this, element).parse(), false, startSqlPos);
        }
        if (from == null) {
            throw new AnnotationParsingException("View doesn't have @From annotation", this.f);
        }
        this.sql.insert(startSqlPos, this.select.toString());
        Where where = this.parserEnv.getTableWhere(from.value());
        String string = fromResult.getExcludeStaticWhere();
        if (string != null && where != null) {
            where = where.exclude(string);
        }
        if (where != null && !where.isEmpty()) {
            this.sql.append(" where ").append(where.copy(fromResult.getAliasName()).getAsCondition());
        }
        this.viewMeta.setSql(this.sql.toString());
        this.addColumns2Env();
        return this.viewMeta;
    }

    protected void addColumns2Env() {
        TableColumns columns = new TableColumns(this.f.getSimpleName().toString(), true);
        for (ViewMeta.ViewTableInfo t : this.viewMeta.getTables()) {
            for (ColumnMeta c : t.getColumns()) {
                columns.add(t.getName(), c.variableName, c.alias, c.sqlType, c.isNotNull);
            }
        }
        this.parserEnv.addTable(this.viewMeta.getViewName(), columns);
    }

    protected void handleFromResult(FromResult result, boolean toHead, int startSqlPos) {
        if (result == null) {
            return;
        }
        if (result.getColumns() != null) {
            this.viewMeta.addTable(new ViewMeta.ViewTableInfo(result.getAliasName(), result.getTableName(), result.getColumns()), toHead);
            if (toHead && this.select.length() > 0) {
                this.select.insert(0, result.getSelectSql() + ", ");
            } else {
                if (this.select.length() > 0) {
                    this.select.append(',');
                }
                this.select.append(result.getSelectSql());
            }
        }
        if (toHead && this.sql.length() > 0) {
            this.sql.insert(startSqlPos, result.getSql());
        } else {
            this.sql.append(result.getSql());
        }
    }

    public Element getAliasElement(String aliasName) {
        return this.aliases.get(aliasName);
    }

    public void regAlias(String aliasName, Element e) {
        this.aliases.put(aliasName, e);
    }

    public String getClassName() {
        return this.f.getSimpleName().toString();
    }
}

