/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.logger;

import com.annotatedsql.processor.ProcessorLogger;
import com.annotatedsql.processor.logger.ILogger;
import java.util.Collection;
import javax.lang.model.element.Element;

public class TagLogger
implements ILogger {
    private final ProcessorLogger logger;
    private final String tag;

    public TagLogger(String tag, ProcessorLogger logger) {
        this.tag = tag;
        this.logger = logger;
    }

    public ProcessorLogger getLogger() {
        return this.logger;
    }

    @Override
    public void w(String msg) {
        this.logger.w("[" + this.tag + "] " + msg);
    }

    @Override
    public void w(String msg, Element element) {
        this.logger.w("[" + this.tag + "] " + msg, element);
    }

    @Override
    public void i(String msg) {
        this.logger.i("[" + this.tag + "] " + msg);
    }

    @Override
    public void i(String msg, Element element) {
        this.logger.i("[" + this.tag + "] " + msg, element);
    }

    @Override
    public void e(String msg, Throwable e, Element element) {
        this.logger.e("[" + this.tag + "] " + msg, e, element);
    }

    @Override
    public void e(String msg, Throwable e) {
        this.logger.e("[" + this.tag + "] " + msg, e);
    }

    @Override
    public void e(String msg, Element e) {
        this.logger.e("[" + this.tag + "] " + msg, e);
    }

    @Override
    public void e(String msg, Element ... elms) {
        this.logger.e("[" + this.tag + "] " + msg, elms);
    }

    @Override
    public void e(String msg, Collection<? extends Element> elms) {
        this.logger.e("[" + this.tag + "] " + msg, elms);
    }
}

