/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.ftl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableColumns
implements Iterable<String> {
    private final boolean isView;
    private final String className;
    private final Map<String, String> column2variable = new LinkedHashMap<String, String>();
    private final Map<String, String> variable2columns = new LinkedHashMap<String, String>();

    public TableColumns(String className, boolean isView) {
        this.isView = isView;
        this.className = className;
    }

    public void add(String variable, String column) {
        this.column2variable.put(column, variable);
        this.variable2columns.put(variable, column);
    }

    public void add(String clazz, String variable, String column) {
        String var = clazz.toUpperCase() + "_" + variable;
        this.column2variable.put(column, var);
        this.variable2columns.put(var, column);
    }

    public String getColumn(String variable) {
        return this.variable2columns.get(variable);
    }

    public String getVariable(String column) {
        return this.column2variable.get(column);
    }

    public boolean isEmpty() {
        return this.column2variable.isEmpty();
    }

    public boolean contains(String column) {
        return this.column2variable.containsKey(column);
    }

    @Override
    public Iterator<String> iterator() {
        return this.column2variable.keySet().iterator();
    }

    public List<String> toColumnsList() {
        return new ArrayList<String>(this.column2variable.keySet());
    }

    public boolean isView() {
        return this.isView;
    }

    public String getClassName() {
        return this.className;
    }
}

