/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.ftl;

import com.annotatedsql.ftl.AltNotify;
import com.annotatedsql.ftl.TriggerMeta;
import com.annotatedsql.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UriMeta {
    private final String path;
    private final int code;
    private final String tableLink;
    private final String codeHex;
    private final boolean isItem;
    private final String selectColumn;
    private final List<AltNotify> altNotify;
    private final boolean onlyQuery;
    private final List<TriggerMeta> triggers;
    private final boolean rawQuery;

    public UriMeta(String path, int code, boolean isItem, String selectColumn, String tableLink, String[] altNotify, boolean onlyQuery, List<TriggerMeta> triggers, boolean rawQuery) {
        this.path = path;
        this.code = code;
        this.tableLink = tableLink;
        this.isItem = isItem;
        this.selectColumn = selectColumn;
        this.onlyQuery = onlyQuery;
        this.triggers = triggers;
        this.rawQuery = rawQuery;
        this.codeHex = "0x" + Integer.toHexString(code);
        if (altNotify != null && altNotify.length != 0) {
            this.altNotify = new ArrayList<AltNotify>();
            for (String n : altNotify) {
                if (TextUtils.isEmpty(n)) continue;
                this.altNotify.add(new AltNotify(n));
            }
        } else {
            this.altNotify = Collections.emptyList();
        }
    }

    public String getPath() {
        return this.path;
    }

    public int getCode() {
        return this.code;
    }

    public String getTableLink() {
        return this.tableLink;
    }

    public String getCodeHex() {
        return this.codeHex;
    }

    public boolean isItem() {
        return this.isItem;
    }

    public String getSelectColumn() {
        return this.selectColumn;
    }

    public List<AltNotify> getAltNotify() {
        return this.altNotify;
    }

    public boolean isOnlyQuery() {
        return this.onlyQuery || this.rawQuery;
    }

    public List<TriggerMeta> getTriggers() {
        return this.triggers;
    }

    public boolean isTriggered() {
        return this.triggers != null && this.triggers.size() != 0;
    }

    public boolean isRawQuery() {
        return this.rawQuery;
    }

    public boolean isHasAltNotify() {
        return !this.altNotify.isEmpty();
    }
}

