/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.sql;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.sql.Column;
import com.annotatedsql.annotation.sql.PrimaryKey;
import com.annotatedsql.annotation.sql.Table;
import com.annotatedsql.ftl.TableColumns;
import com.annotatedsql.processor.sql.ColumnProcessor;
import com.annotatedsql.processor.sql.TableResult;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;

public class TableParser {
    private final Element c;
    private final ParserEnv parserEnv;

    public TableParser(Element c, ParserEnv parserEnv) {
        this.c = c;
        this.parserEnv = parserEnv;
    }

    public TableResult parse() {
        TableColumns tableColumns = new TableColumns(this.c.getSimpleName().toString(), false);
        Table table = this.c.getAnnotation(Table.class);
        String name = table.value();
        if (this.parserEnv.containsTable(name)) {
            throw new AnnotationParsingException(String.format("Table/View with name '%s' alredy defined", name), this.c);
        }
        List<? extends Element> fields = this.c.getEnclosedElements();
        StringBuilder sql = new StringBuilder(fields.size() * 32);
        sql.append("create table ").append(name);
        int pos = sql.length();
        int columnCount = 0;
        boolean hasPrimaryKey = false;
        for (Element element : fields) {
            Column column = element.getAnnotation(Column.class);
            if (column == null) continue;
            ColumnProcessor.ColumnMeta meta = ColumnProcessor.create((VariableElement)element);
            tableColumns.add(element.getSimpleName().toString(), meta.name);
            hasPrimaryKey |= meta.isPrimary;
            sql.append(',').append(meta.sql);
            ++columnCount;
        }
        if (columnCount == 0) {
            throw new AnnotationParsingException("Table doesn't have columns", this.c);
        }
        PrimaryKey pk = this.c.getAnnotation(PrimaryKey.class);
        if (pk != null && pk.columns().length > 0) {
            if (hasPrimaryKey) {
                throw new AnnotationParsingException("Table has more that one PRIMARY KEY", this.c);
            }
            TableParser.proceedPk(sql, pk.columns());
        }
        sql.setCharAt(pos, '(');
        sql.append(')');
        this.parserEnv.addTable(name, tableColumns);
        return new TableResult(sql.toString(), tableColumns.toColumnsList());
    }

    private static void proceedPk(StringBuilder sql, String[] columns) {
        sql.append(", PRIMARY KEY(");
        for (String column : columns) {
            sql.append(' ').append(column).append(',');
        }
        sql.setLength(sql.length() - 1);
        sql.append(")");
    }
}

