/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.sql;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.sql.Index;
import com.annotatedsql.annotation.sql.RawQuery;
import com.annotatedsql.annotation.sql.Schema;
import com.annotatedsql.annotation.sql.SimpleView;
import com.annotatedsql.annotation.sql.Table;
import com.annotatedsql.ftl.IndexMeta;
import com.annotatedsql.ftl.SchemaMeta;
import com.annotatedsql.ftl.TableMeta;
import com.annotatedsql.processor.ProcessorLogger;
import com.annotatedsql.processor.sql.IndexProcessor;
import com.annotatedsql.processor.sql.RawQueryParser;
import com.annotatedsql.processor.sql.SimpleViewParser;
import com.annotatedsql.processor.sql.TableParser;
import com.annotatedsql.processor.sql.TableResult;
import com.annotatedsql.util.TextUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.annotatedsql.annotation.sql.Schema"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class SQLProcessor
extends AbstractProcessor {
    private ProcessorLogger logger;
    private Configuration cfg = new Configuration();
    private Map<String, List<String>> tableColumns = new HashMap<String, List<String>>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.logger = new ProcessorLogger(this.processingEnv.getMessager());
        this.logger.i("SQLProcessor started");
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        this.cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/res"));
        try {
            return this.processTable(roundEnv);
        }
        catch (AnnotationParsingException e) {
            this.logger.e(e.getMessage(), e.getElements());
            return false;
        }
    }

    private boolean processTable(RoundEnvironment roundEnv) {
        Schema schema;
        Element e;
        this.logger.i("SQLProcessor processTable");
        Set<? extends Element> schemaElements = roundEnv.getElementsAnnotatedWith(Schema.class);
        if (schemaElements != null && schemaElements.size() != 0) {
            if (schemaElements.size() != 1) {
                for (Element element : schemaElements) {
                    this.logger.e("Please use one schema file", element);
                }
                return false;
            }
            e = schemaElements.iterator().next();
            schema = e.getAnnotation(Schema.class);
            if (TextUtils.isEmpty(schema.className())) {
                this.logger.e("Schema name can't be empty", e);
                return false;
            }
        } else {
            return false;
        }
        SchemaMeta schema2 = new SchemaMeta(e.getSimpleName().toString(), schema.className(), e.getSimpleName().toString());
        schema2.setDbName(schema.dbName());
        schema2.setDbVersion(schema.dbVersion());
        PackageElement packageElement = (PackageElement)e.getEnclosingElement();
        String pkgName = packageElement.getQualifiedName().toString();
        this.logger.i("SQLProcessor pkgName found: " + pkgName);
        schema2.setPkgName(pkgName);
        ParserEnv parserEnv = new ParserEnv(schema2.getStoreClassName());
        for (Element element : roundEnv.getElementsAnnotatedWith(Table.class)) {
            this.logger.i("SQLProcessor table found: " + element.getSimpleName());
            Table table = element.getAnnotation(Table.class);
            TableResult tableInfo = new TableParser(element, parserEnv).parse();
            this.tableColumns.put(table.value(), tableInfo.getColumns());
            schema2.addTable(new TableMeta(table.value(), tableInfo.getSql()));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Index.class)) {
            this.logger.i("SQLProcessor index found: " + element.getSimpleName());
            Index index = element.getAnnotation(Index.class);
            String sql = IndexProcessor.create(element);
            schema2.addIndex(new IndexMeta(index.name(), sql));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(SimpleView.class)) {
            this.logger.i("SQLProcessor simple view found: " + element.getSimpleName());
            schema2.addView(new SimpleViewParser(element, parserEnv).parse());
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RawQuery.class)) {
            this.logger.i("SQLProcessor raw query found: " + element.getSimpleName());
            schema2.addQuery(new RawQueryParser(element, parserEnv).parse());
        }
        if (schema2.isEmpty()) {
            return false;
        }
        this.processSchema(schema2);
        this.processSchemaExt(schema2);
        return true;
    }

    private void processSchema(SchemaMeta model) {
        this.processTemplateForModel(model, "schema.ftl", null);
    }

    private void processSchemaExt(SchemaMeta model) {
        this.processTemplateForModel(model, "schema_extend.ftl", "2");
    }

    private void processTemplateForModel(SchemaMeta model, String templateName, String postfix) {
        try {
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(model.getPkgName() + "." + model.getClassName() + (postfix == null ? "" : postfix), new Element[0]);
            this.logger.i("Creating file:  " + model.getPkgName() + "." + file.getName());
            Writer out = file.openWriter();
            Template t = this.cfg.getTemplate(templateName);
            t.process((Object)model, out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.logger.e("EntityProcessor IOException: ", e);
        }
        catch (TemplateException e) {
            this.logger.e("EntityProcessor TemplateException: ", e);
        }
    }
}

