/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.sql.view;

import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.sql.Join;
import com.annotatedsql.ftl.ColumnMeta;
import com.annotatedsql.processor.sql.SimpleViewParser;
import com.annotatedsql.processor.sql.view.FromResult;
import com.annotatedsql.processor.sql.view.ViewTableColumnParser;
import com.annotatedsql.util.Where;
import java.util.List;
import javax.lang.model.element.Element;

public class JoinParser
extends ViewTableColumnParser<FromResult, Join> {
    public JoinParser(ParserEnv parserEnv, SimpleViewParser parentParser, Element f) {
        super(parserEnv, parentParser, f, false);
    }

    @Override
    public FromResult parse() {
        this.checkColumnExists(((Join)this.annotation).joinColumn());
        StringBuilder sql = new StringBuilder();
        switch (((Join)this.annotation).type()) {
            case INNER: {
                sql.append(" JOIN ");
                break;
            }
            case LEFT: {
                sql.append(" LEFT OUTER JOIN ");
                break;
            }
            case RIGHT: {
                sql.append(" RIGHT OUTER JOIN ");
                break;
            }
            case CROSS: {
                sql.append(" CROSS JOIN ");
            }
        }
        sql.append(((Join)this.annotation).joinTable()).append(" AS ").append(this.aliasName).append(" ON ").append(this.aliasName).append('.').append(((Join)this.annotation).joinColumn()).append(" = ").append(((Join)this.annotation).onTableAlias()).append('.').append(((Join)this.annotation).onColumn());
        Where where = this.parserEnv.getTableWhere(this.tableName);
        if (where != null && !where.isEmpty()) {
            sql.append(" and ").append(where.copy(this.aliasName).getAsCondition());
        }
        List<ColumnMeta> columns = this.parseColumns();
        return new FromResult(this.aliasName, sql.toString(), JoinParser.toSqlSelect(columns), columns);
    }

    @Override
    public Class<Join> getAnnotationClass() {
        return Join.class;
    }

    @Override
    public String parseTableName() {
        return ((Join)this.annotation).joinTable();
    }
}

