/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.provider;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.provider.Provider;
import com.annotatedsql.annotation.provider.Trigger;
import com.annotatedsql.annotation.provider.Triggers;
import com.annotatedsql.annotation.provider.URI;
import com.annotatedsql.annotation.sql.RawQuery;
import com.annotatedsql.annotation.sql.SimpleView;
import com.annotatedsql.annotation.sql.Table;
import com.annotatedsql.ftl.ProviderMeta;
import com.annotatedsql.ftl.TriggerMeta;
import com.annotatedsql.ftl.UriMeta;
import com.annotatedsql.processor.ProcessorLogger;
import com.annotatedsql.processor.sql.TableParser;
import com.annotatedsql.processor.sql.TableResult;
import com.annotatedsql.util.TextUtils;
import com.annotatedsql.util.Where;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.annotatedsql.annotation.provider.Provider"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ProviderProcessor
extends AbstractProcessor {
    private static final int MATCH_TYPE_ITEM = 1;
    private static final int MATCH_TYPE_DIR = 2;
    private int elementCode = 4096;
    private ProcessorLogger logger;
    private Configuration cfg = new Configuration();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.logger = new ProcessorLogger(this.processingEnv.getMessager());
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        this.cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/res"));
        try {
            return this.processSchema(roundEnv);
        }
        catch (AnnotationParsingException e) {
            this.logger.e(e.getMessage(), e.getElements());
            return false;
        }
    }

    private boolean processSchema(RoundEnvironment roundEnv) {
        List<UriMeta> uris;
        Provider provider;
        Element e;
        Set<? extends Element> providerElements = roundEnv.getElementsAnnotatedWith(Provider.class);
        if (providerElements != null && providerElements.size() != 0) {
            if (providerElements.size() != 1) {
                for (Element element : providerElements) {
                    this.logger.e("Please use one provider file", element);
                }
                return false;
            }
            e = providerElements.iterator().next();
            provider = e.getAnnotation(Provider.class);
            if (TextUtils.isEmpty(provider.name())) {
                this.logger.e("Provider name can't be empty", e);
                return false;
            }
        } else {
            return false;
        }
        ProviderMeta provider2 = new ProviderMeta(e.getSimpleName().toString(), provider.name());
        PackageElement pkg = (PackageElement)e.getEnclosingElement();
        provider2.setPkgName(pkg.getQualifiedName().toString());
        provider2.setSchemaClassName(provider.schemaClass());
        provider2.setOpenHelperClass(provider.openHelperClass());
        provider2.setAuthority(provider.authority());
        provider2.setSupportTransaction(provider.supportTransaction());
        provider2.setBulkInsertMode(provider.bulkInsertMode());
        provider2.setInsertMode(provider.insertMode());
        for (Element element : roundEnv.getElementsAnnotatedWith(Table.class)) {
            TableResult tableInfo;
            List<UriMeta> uris2;
            if (!(element instanceof TypeElement) || (uris2 = this.processTable(element, (tableInfo = new TableParser((TypeElement)element, new ParserEnv(null), this.logger).parse()).getWhere())) == null || uris2.isEmpty()) continue;
            provider2.addImport(((TypeElement)element).getQualifiedName().toString());
            provider2.addUris(uris2);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(SimpleView.class)) {
            uris = this.processTable(element, null);
            if (uris == null || uris.isEmpty()) continue;
            provider2.addImport(((TypeElement)element).getQualifiedName().toString());
            provider2.addUris(uris);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(RawQuery.class)) {
            uris = this.processQuery(element);
            if (uris == null || uris.isEmpty()) continue;
            provider2.addImport(((TypeElement)element).getQualifiedName().toString());
            provider2.addUris(this.processQuery(element));
        }
        this.processTemplateForModel(provider2);
        return true;
    }

    private List<UriMeta> processQuery(Element element) {
        String parentName = element.getSimpleName().toString();
        RawQuery rawQuery = element.getAnnotation(RawQuery.class);
        String from = "SQL_QUERY_" + rawQuery.value().toUpperCase();
        return this.processUri(element, parentName, from, null, true);
    }

    private List<UriMeta> processTable(Element element, Where where) {
        String parentName = element.getSimpleName().toString();
        String nameField = this.findName(element);
        if (nameField == null) {
            throw new AnnotationParsingException("Can't find table/view name. Please define field TABLE_NAME or VIEW_NAME ", element);
        }
        String from = parentName + "." + nameField;
        return this.processUri(element, parentName, from, where, false);
    }

    private List<UriMeta> processUri(Element element, String parentName, String from, Where builder, boolean rawQuery) {
        ArrayList<UriMeta> uris = new ArrayList<UriMeta>();
        for (Element element2 : element.getEnclosedElements()) {
            URI uri = element2.getAnnotation(URI.class);
            if (uri == null) continue;
            ArrayList<TriggerMeta> triggersList = new ArrayList<TriggerMeta>();
            this.validateTrigger(element2, triggersList, element2.getAnnotation(Trigger.class));
            this.validateTrigger(element2, triggersList, element2.getAnnotation(Triggers.class));
            String pathValue = (String)((VariableElement)element2).getConstantValue();
            String path = parentName + "." + element2.getSimpleName().toString();
            if (uri.type() == URI.Type.DIR_AND_ITEM && !rawQuery) {
                uris.add(this.createUriMeta(URI.Type.DIR, path, uri.column(), pathValue, from, uri.altNotify(), uri.onlyQuery(), triggersList, builder, rawQuery));
                uris.add(this.createUriMeta(URI.Type.ITEM, path, uri.column(), pathValue, from, uri.altNotify(), uri.onlyQuery(), null, builder, rawQuery));
                continue;
            }
            uris.add(this.createUriMeta(uri.type(), path, uri.column(), pathValue, from, uri.altNotify(), uri.onlyQuery(), triggersList, builder, rawQuery));
        }
        return uris;
    }

    private void validateTrigger(Element e, List<TriggerMeta> triggersList, Triggers triggers) {
        if (triggers != null) {
            for (Trigger t : triggers.value()) {
                this.validateTrigger(e, triggersList, t);
            }
        }
    }

    private void validateTrigger(Element e, List<TriggerMeta> triggers, Trigger trigger) {
        if (trigger == null) {
            return;
        }
        String triggerMethod = trigger.name().trim();
        if (TextUtils.isEmpty(triggerMethod)) {
            throw new AnnotationParsingException("Trigger method name is empty", e);
        }
        triggers.add(new TriggerMeta(triggerMethod, trigger.type(), trigger.when() == Trigger.When.BEFORE));
    }

    private UriMeta createUriMeta(URI.Type type, String path, String selectColumn, String pathValue, String from, String[] altNotify, boolean onlyQuery, List<TriggerMeta> triggers, Where builder, boolean rawQuery) {
        if (type == URI.Type.ITEM && !pathValue.endsWith("#")) {
            path = !pathValue.endsWith("/") ? path + " + \"/#\"" : path + " + \"#\"";
        }
        int typeMask = type == URI.Type.DIR ? 2 : 1;
        int code = this.elementCode | typeMask;
        this.elementCode += 16;
        return new UriMeta(path, code, type == URI.Type.ITEM, selectColumn, from, altNotify, onlyQuery, triggers, rawQuery, builder);
    }

    private String findName(Element element) {
        for (Element element2 : element.getEnclosedElements()) {
            String simpleName = element2.getSimpleName().toString();
            if (!"TABLE_NAME".equals(simpleName) && !"VIEW_NAME".equals(simpleName)) continue;
            return simpleName;
        }
        return null;
    }

    private void processTemplateForModel(ProviderMeta model) {
        try {
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(model.getPkgName() + "." + model.getClassName(), new Element[0]);
            this.logger.i("Creating file:  " + model.getPkgName() + "." + file.getName());
            Writer out = file.openWriter();
            Template t = this.cfg.getTemplate("provider.ftl");
            t.process((Object)model, out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.logger.e("EntityProcessor IOException: ", e);
        }
        catch (TemplateException e) {
            this.logger.e("EntityProcessor TemplateException: ", e);
        }
    }
}

