/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.sql.view;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.sql.RawJoin;
import com.annotatedsql.ftl.ColumnMeta;
import com.annotatedsql.processor.sql.SimpleViewParser;
import com.annotatedsql.processor.sql.view.FromResult;
import com.annotatedsql.processor.sql.view.ViewTableColumnParser;
import com.annotatedsql.util.TextUtils;
import java.util.List;
import javax.lang.model.element.Element;

public class RawJoinParser
extends ViewTableColumnParser<FromResult, RawJoin> {
    public RawJoinParser(ParserEnv parserEnv, SimpleViewParser parentParser, Element f) {
        super(parserEnv, parentParser, f, false);
    }

    @Override
    public FromResult parse() {
        if (TextUtils.isEmpty(((RawJoin)this.annotation).onCondition())) {
            throw new AnnotationParsingException("'ON' condition is empty", this.field);
        }
        StringBuilder sql = new StringBuilder();
        switch (((RawJoin)this.annotation).type()) {
            case INNER: {
                sql.append(" JOIN ");
                break;
            }
            case LEFT: {
                sql.append(" LEFT OUTER JOIN ");
                break;
            }
            case RIGHT: {
                sql.append(" RIGHT OUTER JOIN ");
                break;
            }
            case CROSS: {
                sql.append(" CROSS JOIN ");
            }
        }
        sql.append(((RawJoin)this.annotation).joinTable()).append(" AS ").append(this.aliasName).append(" ON ").append(((RawJoin)this.annotation).onCondition());
        List<ColumnMeta> columns = this.parseColumns();
        return new FromResult(this.aliasName, sql.toString(), RawJoinParser.toSqlSelect(columns), columns, null);
    }

    @Override
    public Class<RawJoin> getAnnotationClass() {
        return RawJoin.class;
    }

    @Override
    public String parseTableName() {
        return ((RawJoin)this.annotation).joinTable();
    }
}

