/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature;

import com.github.hetianyi.boot.ready.common.util.CollectionUtil;
import com.github.hetianyi.plugins.generator.common.Slot;
import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotHelper {
    private static final Logger log = LoggerFactory.getLogger(SlotHelper.class);

    public static void replaceFieldRange(ClassGenerator generator, BiFunction<List<Slot>, ClassGenerator, List<Slot>> slotFunction) {
        List<Slot> originSlots = generator.getSlots();
        if (CollectionUtil.isNullOrEmpty(originSlots)) {
            return;
        }
        int size = originSlots.size();
        int start = -1;
        int end = -1;
        for (int i = size - 1; i >= 0; --i) {
            Slot s = originSlots.get(i);
            if (s.getType() == SlotType.FIELD_END) {
                if (start != -1) {
                    throw new RuntimeException("\u7ed3\u6784\u9519\u8bef");
                }
                end = i;
            }
            if (s.getType() != SlotType.FIELD_START) continue;
            if (end == -1) {
                throw new RuntimeException("\u7ed3\u6784\u9519\u8bef");
            }
            start = i;
            ImmutableList fieldRangeSlots = ImmutableList.copyOf(originSlots.subList(start, end + 1));
            List<Slot> replacedSlots = slotFunction.apply((List<Slot>)fieldRangeSlots, generator);
            for (int j = start; j <= end; ++j) {
                originSlots.remove(start);
            }
            if (!CollectionUtil.isNullOrEmpty(replacedSlots)) {
                originSlots.addAll(start + 1, replacedSlots);
            }
            start = -1;
            end = -1;
        }
    }

    public static void scan(ClassGenerator generator, BiFunction<Slot, ClassGenerator, Slot> slotFunction) {
        List<Slot> originSlots = generator.getSlots();
        if (CollectionUtil.isNullOrEmpty(originSlots)) {
            return;
        }
        for (int i = 0; i < originSlots.size(); ++i) {
            Slot s = originSlots.get(i);
            Slot newSlot = slotFunction.apply(s, generator);
            originSlots.set(i, newSlot);
        }
    }

    public static List<Slot> insertBefore(ClassGenerator generator, SlotType markup, BiFunction<Slot, ClassGenerator, List<Slot>> slotFunction) {
        List<Slot> originSlots = generator.getSlots();
        if (CollectionUtil.isNullOrEmpty(originSlots)) {
            return originSlots;
        }
        int cursor = 0;
        do {
            Slot s;
            if ((s = originSlots.get(cursor)).getType() != markup) continue;
            List<Slot> slots = Optional.ofNullable(slotFunction.apply(s, generator)).orElse((List<Slot>)ImmutableList.of());
            for (Slot slot : slots) {
                originSlots.add(cursor, slot);
                ++cursor;
            }
        } while (++cursor < originSlots.size());
        return originSlots;
    }

    public static List<Slot> insertAfter(ClassGenerator generator, SlotType markup, BiFunction<Slot, ClassGenerator, List<Slot>> slotFunction) {
        List<Slot> originSlots = generator.getSlots();
        if (CollectionUtil.isNullOrEmpty(originSlots)) {
            return originSlots;
        }
        int cursor = 0;
        do {
            Slot s;
            if ((s = originSlots.get(cursor)).getType() != markup) continue;
            List<Slot> slots = Optional.ofNullable(slotFunction.apply(s, generator)).orElse((List<Slot>)ImmutableList.of());
            for (Slot slot : slots) {
                originSlots.add(cursor + 1, slot);
                ++cursor;
            }
        } while (++cursor < originSlots.size());
        return originSlots;
    }

    public static List<Slot> insertBefore(ClassGenerator generator, SlotType markup, Slot ... slots) {
        List<Slot> originSlots = generator.getSlots();
        if (CollectionUtil.isNullOrEmpty(originSlots)) {
            return originSlots;
        }
        int cursor = 0;
        do {
            Slot s;
            if ((s = originSlots.get(cursor)).getType() != markup) continue;
            for (Slot slot : slots) {
                originSlots.add(cursor, slot);
                ++cursor;
            }
        } while (++cursor < originSlots.size());
        return originSlots;
    }

    public static List<Slot> insertAfter(ClassGenerator generator, SlotType markup, Slot ... slots) {
        List<Slot> originSlots = generator.getSlots();
        if (CollectionUtil.isNullOrEmpty(originSlots)) {
            return originSlots;
        }
        int cursor = 0;
        do {
            Slot s;
            if ((s = originSlots.get(cursor)).getType() != markup) continue;
            for (Slot slot : slots) {
                originSlots.add(cursor + 1, slot);
                ++cursor;
            }
        } while (++cursor < originSlots.size());
        return originSlots;
    }
}

