/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.jpa;

import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.CustomFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.IndentSlot;
import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaFieldAnnotationFeature
extends CustomFeature {
    private static final Logger log = LoggerFactory.getLogger(JpaFieldAnnotationFeature.class);

    public JpaFieldAnnotationFeature() {
        super(SlotType.FIELD_HEAD, CustomFeature.InsertLocation.AFTER, (s, g) -> {
            TableColumn column = (TableColumn)s.getAttribute("column");
            g.getImports().add("javax.persistence.Column");
            if (column.isId()) {
                g.getImports().add("javax.persistence.Id");
                g.getImports().add("javax.persistence.GeneratedValue");
                g.getImports().add("javax.persistence.GenerationType");
                if (!column.isAutoIncrement()) {
                    g.getImports().add("org.hibernate.annotations.GenericGenerator");
                }
                return ImmutableList.of((Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@Id\n"), (Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@Column(name = \"", column.getName(), "\")\n"), (Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@GeneratedValue(strategy = GenerationType.", column.isAutoIncrement() ? "IDENTITY)\n" : "AUTO, generator = \"assigned\")\n" + IndentSlot.getInstance().getContent() + "@GenericGenerator(name = \"assigned\", strategy = \"assigned\")\n"));
            }
            return ImmutableList.of((Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@Column(name = \"", column.getName(), "\")\n"));
        });
        log.debug("\u5e94\u7528Feature -> JpaFieldAnnotationFeature");
    }
}

