/*
 * Decompiled with CFR 0.152.
 */
package com.github.hsnghrld.idpay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public enum ErrorCode {
    _0("Unknown error ({0})", "\u062e\u0637\u0627\u06cc \u0646\u0627\u0645\u0634\u062e\u0635 ({0})"),
    _11("User is blocked.", "\u06a9\u0627\u0631\u0628\u0631 \u0645\u0633\u062f\u0648\u062f \u0634\u062f\u0647 \u0627\u0633\u062a."),
    _12("API key not found.", "\u06a9\u0644\u06cc\u062f API \u06cc\u0627\u0641\u062a \u0646\u0634\u062f."),
    _13("Your request has been sent from {ip}. This IP does not match the IPs registered in the web service.", "\u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0634\u0645\u0627 \u0627\u0632 {ip} \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a. \u0627\u06cc\u0646 IP \u0628\u0627 IP \u0647\u0627\u06cc \u062b\u0628\u062a \u0634\u062f\u0647 \u062f\u0631 \u0648\u0628 \u0633\u0631\u0648\u06cc\u0633 \u0647\u0645\u062e\u0648\u0627\u0646\u06cc \u0646\u062f\u0627\u0631\u062f."),
    _14("Your web service is being reviewed or not verified.", "\u0648\u0628 \u0633\u0631\u0648\u06cc\u0633 \u0634\u0645\u0627 \u062f\u0631 \u062d\u0627\u0644 \u0628\u0631\u0631\u0633\u06cc \u0627\u0633\u062a \u0648 \u06cc\u0627 \u062a\u0627\u06cc\u06cc\u062f \u0646\u0634\u062f\u0647 \u0627\u0633\u062a."),
    _21("The bank account connected to the web service has not been verified.", "\u062d\u0633\u0627\u0628 \u0628\u0627\u0646\u06a9\u06cc \u0645\u062a\u0635\u0644 \u0628\u0647 \u0648\u0628 \u0633\u0631\u0648\u06cc\u0633 \u062a\u0627\u06cc\u06cc\u062f \u0646\u0634\u062f\u0647 \u0627\u0633\u062a."),
    _22("Web service not found.", "\u0648\u0628 \u0633\u0631\u06cc\u0633 \u06cc\u0627\u0641\u062a \u0646\u0634\u062f."),
    _23("Web service validation failed.", "\u0627\u0639\u062a\u0628\u0627\u0631 \u0633\u0646\u062c\u06cc \u0648\u0628 \u0633\u0631\u0648\u06cc\u0633 \u0646\u0627\u0645\u0648\u0641\u0642 \u0628\u0648\u062f."),
    _24("The bank account associated with this web service has been disabled.", "\u062d\u0633\u0627\u0628 \u0628\u0627\u0646\u06a9\u06cc \u0645\u0631\u062a\u0628\u0637 \u0628\u0627 \u0627\u06cc\u0646 \u0648\u0628 \u0633\u0631\u0648\u06cc\u0633 \u063a\u06cc\u0631 \u0641\u0639\u0627\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a."),
    _31("The id must not be empty.", "\u06a9\u062f \u062a\u0631\u0627\u06a9\u0646\u0634 (id) \u0646\u0628\u0627\u06cc\u062f \u062e\u0627\u0644\u06cc \u0628\u0627\u0634\u062f."),
    _32("The order_id must not be blank.", "\u0634\u0645\u0627\u0631\u0647 \u0633\u0641\u0627\u0631\u0634 (order_id) \u0646\u0628\u0627\u06cc\u062f \u062e\u0627\u0644\u06cc \u0628\u0627\u0634\u062f."),
    _33("The amount should not be empty.", "\u0645\u0628\u0644\u063a (amount) \u0646\u0628\u0627\u06cc\u062f \u062e\u0627\u0644\u06cc \u0628\u0627\u0634\u062f."),
    _34("The amount must be more than {min-amount} Rials.", "\u0645\u0628\u0644\u063a (amount) \u0628\u0627\u06cc\u062f \u0628\u06cc\u0634\u062a\u0631 \u0627\u0632 {min-amount} \u0631\u06cc\u0627\u0644 \u0628\u0627\u0634\u062f."),
    _35("The amount must be less than {max-amount} Rials.", "\u0645\u0628\u0644\u063a (amount) \u0628\u0627\u06cc\u062f \u06a9\u0645\u062a\u0631 \u0627\u0632 {max-amount} \u0631\u06cc\u0627\u0644 \u0628\u0627\u0634\u062f."),
    _36("The amount is more than allowed.", "\u0645\u0628\u0644\u063a (amount) \u0628\u06cc\u0634\u062a\u0631 \u0627\u0632 \u062d\u062f \u0645\u062c\u0627\u0632 \u0627\u0633\u062a."),
    _37("The callback must not be empty.", "\u0622\u062f\u0631\u0633 \u0628\u0627\u0632\u06af\u0634\u062a (callback) \u0646\u0628\u0627\u06cc\u062f \u062e\u0627\u0644\u06cc \u0628\u0627\u0634\u062f."),
    _38("Your request has been sent from {domain}. The callback domain does not match the address registered on the web service.", "\u062f\u0631\u062e\u0648\u0627\u0633\u062a \u0634\u0645\u0627 \u0627\u0632 \u0622\u062f\u0631\u0633 {domain} \u0627\u0631\u0633\u0627\u0644 \u0634\u062f\u0647 \u0627\u0633\u062a. \u062f\u0627\u0645\u0646\u0647 \u0622\u062f\u0631\u0633 \u0628\u0627\u0632\u06af\u0634\u062a (callback) \u0628\u0627 \u0622\u062f\u0631\u0633 \u062b\u0628\u062a \u0634\u062f\u0647 \u062f\u0631 \u0648\u0628 \u0633\u0631\u0648\u06cc\u0633 \u0647\u0645\u062e\u0648\u0627\u0646\u06cc \u0646\u062f\u0627\u0631\u062f."),
    _41("The transaction status filter should be an array (list) of allowed statuses in the documentation.", "\u0641\u06cc\u0644\u062a\u0631 \u0648\u0636\u0639\u06cc\u062a \u062a\u0631\u0627\u06a9\u0646\u0634 \u0647\u0627 \u0645\u06cc \u0628\u0627\u06cc\u0633\u062a \u0622\u0631\u0627\u06cc\u0647 \u0627\u06cc (\u0644\u06cc\u0633\u062a\u06cc) \u0627\u0632 \u0648\u0636\u0639\u06cc\u062a \u0647\u0627\u06cc \u0645\u062c\u0627\u0632 \u062f\u0631 \u0645\u0633\u062a\u0646\u062f\u0627\u062a \u0628\u0627\u0634\u062f."),
    _42("The payment date filter should be an array containing the min and max elements of the timestamp type.", "\u0641\u06cc\u0644\u062a\u0631 \u062a\u0627\u0631\u06cc\u062e \u067e\u0631\u062f\u0627\u062e\u062a \u0645\u06cc \u0628\u0627\u06cc\u0633\u062a \u0622\u0631\u0627\u06cc\u0647 \u0627\u06cc \u0634\u0627\u0645\u0644 \u0627\u0644\u0645\u0646\u062a \u0647\u0627\u06cc min \u0648 max \u0627\u0632 \u0646\u0648\u0639 timestamp \u0628\u0627\u0634\u062f."),
    _43("The settlement date filter should be an array containing the min and max elements of the timestamp type.", "\u0641\u06cc\u0644\u062a\u0631 \u062a\u0627\u0631\u06cc\u062e \u062a\u0633\u0648\u06cc\u0647 \u0645\u06cc \u0628\u0627\u06cc\u0633\u062a \u0622\u0631\u0627\u06cc\u0647 \u0627\u06cc \u0634\u0627\u0645\u0644 \u0627\u0644\u0645\u0646\u062a \u0647\u0627\u06cc min \u0648 max \u0627\u0632 \u0646\u0648\u0639 timestamp \u0628\u0627\u0634\u062f."),
    _51("No transaction was created.", "\u062a\u0631\u0627\u06a9\u0646\u0634 \u0627\u06cc\u062c\u0627\u062f \u0646\u0634\u062f."),
    _52("The query returned no results.", "\u0627\u0633\u062a\u0639\u0644\u0627\u0645 \u0646\u062a\u06cc\u062c\u0647 \u0627\u06cc \u0646\u062f\u0627\u0634\u062a."),
    _53("Payment verification is not possible.", "\u062a\u0627\u06cc\u06cc\u062f \u067e\u0631\u062f\u0627\u062e\u062a \u0627\u0645\u06a9\u0627\u0646 \u067e\u0630\u06cc\u0631 \u0646\u06cc\u0633\u062a."),
    _54("Payment verification period has elapsed.", "\u0645\u062f\u062a \u0632\u0645\u0627\u0646 \u062a\u0627\u06cc\u06cc\u062f \u067e\u0631\u062f\u0627\u062e\u062a \u0633\u067e\u0631\u06cc \u0634\u062f\u0647 \u0627\u0633\u062a.");

    public static final String[] ALL_ERROR_CODES;
    private final String desc_en;
    private final String desc_fa;

    private ErrorCode(String desc_en, String desc_fa) {
        this.desc_en = desc_en;
        this.desc_fa = desc_fa;
    }

    public String getDesc_en() {
        return this.desc_en;
    }

    public String getDesc_fa() {
        return this.desc_fa;
    }

    @NotNull
    public String toString() {
        return super.toString().substring(1);
    }

    @NotNull
    public static ArrayList<String> toString(@NotNull Collection<ErrorCode> statuses) {
        ArrayList<String> statuses_string = new ArrayList<String>();
        for (ErrorCode status : statuses) {
            statuses_string.add(status.toString());
        }
        return statuses_string;
    }

    static {
        ALL_ERROR_CODES = (String[])Arrays.stream(ErrorCode.values()).map(ErrorCode::toString).toArray(String[]::new);
    }
}

