/*
 * Decompiled with CFR 0.152.
 */
package com.github.hsnghrld.idpay;

import com.github.hsnghrld.idpay.CreatePaymentResult;
import com.github.hsnghrld.idpay.GetListOfTransactionsResult;
import com.github.hsnghrld.idpay.Transaction;
import com.github.hsnghrld.idpay.TransactionFilter;
import com.github.hsnghrld.idpay.exception.ApiException;
import com.github.hsnghrld.idpay.exception.NetworkException;
import com.github.hsnghrld.idpay.exception.ValidationException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class IDPay {
    public static final String BASE_URL = "https://api.idpay.ir/";
    public static final String API_VERSION = "v1.1";
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    private final Headers headers;

    public IDPay(String apiKey) {
        this(apiKey, false);
    }

    public IDPay(String apiKey, boolean sandbox) {
        this.headers = new Headers.Builder().add("Content-Type", "application/json").add("Accept", "application/json").add("X-API-KEY", apiKey).add("X-SANDBOX", sandbox + "").build();
    }

    public CreatePaymentResult createPayment(@NotNull String order_id, @NotNull Integer amount, @NotNull String callback) throws ValidationException, NetworkException, ApiException {
        return this.createPayment(order_id, amount, callback, null, null, null, null);
    }

    public CreatePaymentResult createPayment(@NotNull String order_id, @NotNull Integer amount, @NotNull String callback, String name, String phone, String mail, String desc) throws ValidationException, NetworkException, ApiException {
        if (order_id == null || amount == null || callback == null) {
            throw new ValidationException("order_id and amount and callback are required.");
        }
        if (order_id.length() > 50) {
            throw new ValidationException("order_id must be a maximum of 50 characters long.");
        }
        if (amount < 1000 || amount > 500000000) {
            throw new ValidationException("amount must be between 1,000 to 500,000,000.");
        }
        if (callback.length() > 255) {
            throw new ValidationException("callback must be a maximum of 255 characters long.");
        }
        JSONObject body = new JSONObject().put("order_id", (Object)order_id).put("amount", (Object)amount).put("callback", (Object)callback);
        if (name != null) {
            if (name.length() > 255) {
                throw new ValidationException("name must be a maximum of 255 characters long.");
            }
            body.put("name", (Object)name);
        }
        if (phone != null) {
            if (!phone.matches("^([9][8]|[0])?([9][\\d]{9})$")) {
                throw new ValidationException("phone must be like 9382198592 or 09382198592 or 989382198592.");
            }
            body.put("phone", (Object)phone);
        }
        if (mail != null) {
            if (mail.length() > 255) {
                throw new ValidationException("mail must be a maximum of 255 characters long.");
            }
            if (!mail.matches("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\\.[a-zA-Z0-9-]+)$")) {
                throw new ValidationException("mail is not valid.");
            }
            body.put("mail", (Object)mail);
        }
        if (desc != null) {
            if (desc.length() > 255) {
                throw new ValidationException("desc must be a maximum of 255 characters long.");
            }
            body.put("desc", (Object)desc);
        }
        return this.commonPost(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body.toString()), "v1.1/payment", CreatePaymentResult.class);
    }

    public Transaction verifyPayment(@NotNull String id, @NotNull String order_id) throws ValidationException, NetworkException, ApiException {
        if (id == null || order_id == null) {
            throw new ValidationException("id and order_id are required.");
        }
        return this.commonPost(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new JSONObject().put("id", (Object)id).put("order_id", (Object)order_id).toString()), "v1.1/payment/verify", Transaction.class);
    }

    public Transaction inquiryPayment(@NotNull String id, @NotNull String order_id) throws ValidationException, NetworkException, ApiException {
        if (id == null || order_id == null) {
            throw new ValidationException("id and order_id are required.");
        }
        return this.commonPost(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new JSONObject().put("id", (Object)id).put("order_id", (Object)order_id).toString()), "v1.1/payment/inquiry", Transaction.class);
    }

    public GetListOfTransactionsResult getListOfTransactions(Integer page, Integer page_size, TransactionFilter filter) throws NetworkException, ApiException {
        return this.commonPost(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)(filter != null ? filter.toJSONObject().toString() : "{}")), "v1.1/payment/transactions?page=" + (page != null ? page : "0") + "&page_size=" + (page_size != null ? page_size : "5"), GetListOfTransactionsResult.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T commonPost(RequestBody requestBody, String path, Class<T> clazz) throws NetworkException, ApiException {
        try (Response response = HTTP_CLIENT.newCall(new Request.Builder().url(BASE_URL + path).headers(this.headers).post(requestBody).build()).execute();){
            T t = this.handleResponse(response, clazz);
            return t;
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    @Nullable
    private <T> T handleResponse(@NotNull Response response, Class<T> clazz) throws NetworkException, ApiException {
        JSONObject responseBody;
        try {
            if (response.body() == null) {
                throw new NetworkException("Response body is null.");
            }
            String responseBody_string = response.body().string().trim();
            if (responseBody_string.isEmpty()) {
                throw new NetworkException("Response body is empty.");
            }
            responseBody = new JSONObject(responseBody_string);
            if (responseBody.length() == 0) {
                throw new NetworkException("Response body is empty json.");
            }
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
        try {
            if (response.isSuccessful()) {
                return clazz.cast(clazz.getConstructor(JSONObject.class).newInstance(responseBody));
            }
            if (response.code() / 100 == 4) {
                throw new ApiException(responseBody.get("error_code").toString());
            }
            throw new NetworkException("Response code is " + response.code() + ".");
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HTTP_CLIENT.connectionPool().evictAll()));
    }
}

