/*
 * Decompiled with CFR 0.152.
 */
package com.github.hsnghrld.idpay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public enum PaymentStatus {
    _1("Payment not made", "\u067e\u0631\u062f\u0627\u062e\u062a \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a"),
    _2("Payment failed", "\u067e\u0631\u062f\u0627\u062e\u062a \u0646\u0627\u0645\u0648\u0641\u0642 \u0628\u0648\u062f\u0647 \u0627\u0633\u062a"),
    _3("An error has occurred", "\u062e\u0637\u0627 \u0631\u062e \u062f\u0627\u062f\u0647 \u0627\u0633\u062a"),
    _4("Blocked", "\u0628\u0644\u0648\u06a9\u0647 \u0634\u062f\u0647"),
    _5("Return to payer", "\u0628\u0631\u06af\u0634\u062a \u0628\u0647 \u067e\u0631\u062f\u0627\u062e\u062a \u06a9\u0646\u0646\u062f\u0647"),
    _6("Systematically returned", "\u0628\u0631\u06af\u0634\u062a \u062e\u0648\u0631\u062f\u0647 \u0633\u06cc\u0633\u062a\u0645\u06cc"),
    _7("Cancel payment", "\u0627\u0646\u0635\u0631\u0627\u0641 \u0627\u0632 \u067e\u0631\u062f\u0627\u062e\u062a"),
    _8("Moved to payment gateway", "\u0628\u0647 \u062f\u0631\u06af\u0627\u0647 \u067e\u0631\u062f\u0627\u062e\u062a \u0645\u0646\u062a\u0642\u0644 \u0634\u062f"),
    _10("Awaiting payment confirmation", "\u062f\u0631 \u0627\u0646\u062a\u0638\u0627\u0631 \u062a\u0627\u06cc\u06cc\u062f \u067e\u0631\u062f\u0627\u062e\u062a"),
    _100("Payment is approved", "\u067e\u0631\u062f\u0627\u062e\u062a \u062a\u0627\u06cc\u06cc\u062f \u0634\u062f\u0647 \u0627\u0633\u062a"),
    _101("Payment has already been approved", "\u067e\u0631\u062f\u0627\u062e\u062a \u0642\u0628\u0644\u0627 \u062a\u0627\u06cc\u06cc\u062f \u0634\u062f\u0647 \u0627\u0633\u062a"),
    _200("Deposited to the recipient", "\u0628\u0647 \u062f\u0631\u06cc\u0627\u0641\u062a \u06a9\u0646\u0646\u062f\u0647 \u0648\u0627\u0631\u06cc\u0632 \u0634\u062f");

    public static final String[] ALL_PAYMENT_STATUSES;
    private final String desc_en;
    private final String desc_fa;

    private PaymentStatus(String desc_en, String desc_fa) {
        this.desc_en = desc_en;
        this.desc_fa = desc_fa;
    }

    public String getDesc_fa() {
        return this.desc_fa;
    }

    public String getDesc_en() {
        return this.desc_en;
    }

    @NotNull
    public String toString() {
        return super.toString().substring(1);
    }

    @NotNull
    public static ArrayList<String> toString(@NotNull Collection<PaymentStatus> statuses) {
        ArrayList<String> statuses_string = new ArrayList<String>();
        for (PaymentStatus status : statuses) {
            statuses_string.add(status.toString());
        }
        return statuses_string;
    }

    static {
        ALL_PAYMENT_STATUSES = (String[])Arrays.stream(PaymentStatus.values()).map(PaymentStatus::toString).toArray(String[]::new);
    }
}

