/*
 * Decompiled with CFR 0.152.
 */
package com.github.hsnghrld.idpay;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public final class Transaction {
    private final String transaction_string;
    public final short status;
    public final String track_id;
    public final String id;
    public final String order_id;
    public final int amount;
    public final Wage wage;
    public final long date;
    public final Payer payer;
    public final PaymentDetail payment;
    public final Verify verify;
    public final Settlement settlement;

    public Transaction(@NotNull JSONObject object) throws JSONException {
        this.transaction_string = object.toString(4);
        this.status = (short)object.getInt("status");
        this.track_id = object.getString("track_id");
        this.id = object.getString("id");
        this.order_id = object.getString("order_id");
        this.amount = object.getInt("amount");
        this.wage = object.has("wage") && !object.isNull("wage") ? new Wage(object.getJSONObject("wage")) : null;
        this.date = object.getLong("date");
        this.payer = object.has("payer") && !object.isNull("payer") ? new Payer(object.getJSONObject("payer")) : null;
        this.payment = new PaymentDetail(object.getJSONObject("payment"));
        this.verify = new Verify(object.getJSONObject("verify"));
        this.settlement = object.has("settlement") && !object.isNull("settlement") ? new Settlement(object.getJSONObject("settlement")) : null;
    }

    public String toString() {
        return this.transaction_string;
    }

    public static class Settlement {
        private final String settlement_string;
        public final String track_id;
        public final Integer amount;
        public final Long date;

        Settlement(@NotNull JSONObject object) throws JSONException {
            this.settlement_string = object.toString(4);
            this.track_id = object.has("track_id") && !object.isNull("track_id") ? object.getString("track_id") : null;
            this.amount = object.has("amount") && !object.isNull("amount") ? Integer.valueOf(object.getInt("amount")) : null;
            this.date = object.has("date") && !object.isNull("date") ? Long.valueOf(object.getLong("date")) : null;
        }

        public String toString() {
            return this.settlement_string;
        }
    }

    public static class Payer {
        private final String payer_string;
        public final String name;
        public final String phone;
        public final String mail;
        public final String desc;

        Payer(@NotNull JSONObject object) throws JSONException {
            this.payer_string = object.toString(4);
            this.name = object.has("name") && !object.isNull("name") ? object.getString("name") : null;
            this.phone = object.has("phone") && !object.isNull("phone") ? object.getString("phone") : null;
            this.mail = object.has("mail") && !object.isNull("mail") ? object.getString("mail") : null;
            this.desc = object.has("desc") && !object.isNull("desc") ? object.getString("desc") : null;
        }

        public String toString() {
            return this.payer_string;
        }
    }

    public static class Wage {
        private final String wage_string;
        public final String by;
        public final String type;
        public final Integer amount;

        Wage(@NotNull JSONObject object) throws JSONException {
            this.wage_string = object.toString(4);
            this.by = object.has("by") && !object.isNull("by") ? object.getString("by") : null;
            this.type = object.has("type") && !object.isNull("type") ? object.getString("type") : null;
            this.amount = object.has("amount") && !object.isNull("amount") ? Integer.valueOf(object.getInt("amount")) : null;
        }

        public String toString() {
            return this.wage_string;
        }
    }

    public static class Verify {
        private final String verify_string;
        public final Long date;

        Verify(@NotNull JSONObject object) throws JSONException {
            this.verify_string = object.toString(4);
            this.date = object.has("date") && !object.isNull("date") ? Long.valueOf(object.getLong("date")) : null;
        }

        public String toString() {
            return this.verify_string;
        }
    }

    public static class PaymentDetail {
        private final String paymentDetail_string;
        public final String track_id;
        public final Integer amount;
        public final String card_no;
        public final String hashed_card_no;
        public final Long date;

        PaymentDetail(@NotNull JSONObject object) throws JSONException {
            this.paymentDetail_string = object.toString(4);
            this.track_id = object.has("track_id") && !object.isNull("track_id") ? object.getString("track_id") : null;
            this.amount = object.has("amount") && !object.isNull("amount") ? Integer.valueOf(object.getInt("amount")) : null;
            this.card_no = object.has("card_no") && !object.isNull("card_no") ? object.getString("card_no") : null;
            this.hashed_card_no = object.has("hashed_card_no") && !object.isNull("hashed_card_no") ? object.getString("hashed_card_no") : null;
            this.date = object.has("date") && !object.isNull("date") ? Long.valueOf(object.getLong("date")) : null;
        }

        public String toString() {
            return this.paymentDetail_string;
        }
    }
}

