/*
 * Decompiled with CFR 0.152.
 */
package com.github.hsnghrld.idpay;

import com.github.hsnghrld.idpay.PaymentStatus;
import java.time.temporal.ValueRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public final class TransactionFilter {
    public String id = null;
    public String order_id = null;
    public Long amount = null;
    public HashSet<PaymentStatus> statuses = null;
    public String track_id = null;
    public String payment_card_no = null;
    public String payment_hashed_card_no = null;
    public ValueRange payment_date = null;
    public ValueRange settlement_date = null;

    @NotNull
    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        if (this.id != null) {
            object.put("id", (Object)this.id);
        }
        if (this.order_id != null) {
            object.put("order_id", (Object)this.order_id);
        }
        if (this.amount != null) {
            object.put("amount", (Object)this.amount);
        }
        if (this.statuses != null) {
            object.put("status", PaymentStatus.toString(this.statuses));
        }
        if (this.track_id != null) {
            object.put("track_id", (Object)this.track_id);
        }
        if (this.payment_card_no != null) {
            object.put("payment_card_no", (Object)this.payment_card_no);
        }
        if (this.payment_hashed_card_no != null) {
            object.put("payment_hashed_card_no", (Object)this.payment_hashed_card_no);
        }
        if (this.payment_date != null) {
            object.put("payment_date", (Object)new JSONObject().put("min", this.payment_date.getMinimum() / 1000L).put("max", this.payment_date.getMaximum() / 1000L));
        }
        if (this.settlement_date != null) {
            object.put("payment_date", (Object)new JSONObject().put("min", this.settlement_date.getMinimum() / 1000L).put("max", this.settlement_date.getMaximum() / 1000L));
        }
        return object;
    }

    public TransactionFilter id(String id) {
        this.id = id;
        return this;
    }

    public TransactionFilter order_id(String order_id) {
        this.order_id = order_id;
        return this;
    }

    public TransactionFilter amount(long amount) {
        this.amount = amount;
        return this;
    }

    public TransactionFilter statuses(PaymentStatus status, PaymentStatus ... statuses) {
        ArrayList<PaymentStatus> list = new ArrayList<PaymentStatus>();
        list.add(status);
        list.addAll(Arrays.asList(statuses));
        this.statuses = new HashSet(list);
        return this;
    }

    public TransactionFilter track_id(String track_id) {
        this.track_id = track_id;
        return this;
    }

    public TransactionFilter payment_card_no(String payment_card_no) {
        this.payment_card_no = payment_card_no;
        return this;
    }

    public TransactionFilter payment_hashed_card_no(String payment_hashed_card_no) {
        this.payment_hashed_card_no = payment_hashed_card_no;
        return this;
    }

    public TransactionFilter payment_date(ValueRange payment_date) {
        this.payment_date = payment_date;
        return this;
    }

    public TransactionFilter settlement_date(ValueRange settlement_date) {
        this.settlement_date = settlement_date;
        return this;
    }
}

