/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.UnitLowerCompRowMatrix;
import no.uib.cipr.matrix.sparse.UpperCompRowMatrix;

public class ILU
implements Preconditioner {
    private final CompRowMatrix LU;
    private Matrix L;
    private Matrix U;
    private final Vector y;

    public ILU(CompRowMatrix LU) {
        if (!LU.isSquare()) {
            throw new IllegalArgumentException("ILU only applies to square matrices");
        }
        this.LU = LU;
        int n = LU.numRows();
        this.y = new DenseVector(n);
    }

    @Override
    public Vector apply(Vector b, Vector x) {
        this.L.solve(b, this.y);
        return this.U.solve(this.y, x);
    }

    @Override
    public Vector transApply(Vector b, Vector x) {
        this.U.transSolve(b, this.y);
        return this.L.transSolve(this.y, x);
    }

    @Override
    public void setMatrix(Matrix A) {
        this.LU.set(A);
        this.factor();
    }

    /*
     * Unable to fully structure code
     */
    private void factor() {
        n = this.LU.numRows();
        colind = this.LU.getColumnIndices();
        rowptr = this.LU.getRowPointers();
        data = this.LU.getData();
        diagind = ILU.findDiagonalIndices(n, colind, rowptr);
        k = 1;
        while (k < n) {
            i = rowptr[k];
            while (i < diagind[k]) {
                index = colind[i];
                LUii = data[diagind[index]];
                if (LUii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ILU process");
                }
                v0 = i;
                v1 = data[v0] / LUii;
                data[v0] = v1;
                LUki = v1;
                j = diagind[index] + 1;
                l = rowptr[k] + 1;
                ** GOTO lbl28
                {
                    ++l;
                    do {
                        if (l < rowptr[k + 1] && colind[l] < colind[j]) continue block2;
                        if (colind[l] == colind[j]) {
                            v2 = l;
                            data[v2] = data[v2] - LUki * data[j];
                        }
                        ++j;
lbl28:
                        // 2 sources

                    } while (j < rowptr[index + 1]);
                }
                ++i;
            }
            ++k;
        }
        this.L = new UnitLowerCompRowMatrix(this.LU, diagind);
        this.U = new UpperCompRowMatrix(this.LU, diagind);
    }

    private static int[] findDiagonalIndices(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        int k = 0;
        while (k < m) {
            diagind[k] = Arrays.binarySearch(colind, k, rowptr[k], rowptr[k + 1]);
            if (diagind[k] < 0) {
                throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
            }
            ++k;
        }
        return diagind;
    }
}

