/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Vector;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.FormatMap;
import org.j_paine.formatter.FormatOutputList;
import org.j_paine.formatter.FormatParser;
import org.j_paine.formatter.FormatUniv;
import org.j_paine.formatter.InputFormatException;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.InvalidFormatException;
import org.j_paine.formatter.OutputFormatException;
import org.j_paine.formatter.ParseException;
import org.j_paine.formatter.Parsers;
import org.j_paine.formatter.TokenMgrError;

final class Format
extends FormatUniv {
    private Vector elements = new Vector();

    public Format(String string) throws InvalidFormatException {
        FormatParser formatParser = Parsers.theParsers().format_parser;
        FormatParser.ReInit(new StringBufferInputStream(string));
        try {
            Format format = formatParser.Format();
            this.elements = format.elements;
        }
        catch (ParseException parseException) {
            throw new InvalidFormatException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new InvalidFormatException(tokenMgrError.getMessage());
        }
    }

    Format() {
    }

    public void addElement(FormatUniv formatUniv) {
        this.elements.addElement(formatUniv);
    }

    @Override
    public void write(FormatOutputList formatOutputList, PrintStream printStream) throws OutputFormatException {
        for (int i = 0; i < this.elements.size(); ++i) {
            FormatUniv formatUniv = (FormatUniv)this.elements.elementAt(i);
            formatUniv.write(formatOutputList, printStream);
        }
    }

    @Override
    public void read(FormatInputList formatInputList, InputStreamAndBuffer inputStreamAndBuffer, FormatMap formatMap) throws InputFormatException {
        for (int i = 0; i < this.elements.size(); ++i) {
            FormatUniv formatUniv = (FormatUniv)this.elements.elementAt(i);
            formatUniv.read(formatInputList, inputStreamAndBuffer, formatMap);
        }
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i != 0) {
                string = new StringBuffer().append(string).append(", ").toString();
            }
            string = new StringBuffer().append(string).append(this.elements.elementAt(i).toString()).toString();
        }
        return string;
    }
}

