/*
 * Decompiled with CFR 0.152.
 */
package org.j_paine.formatter;

import java.util.Hashtable;
import java.util.Vector;
import org.j_paine.formatter.EndOfKeyVectorOnReadException;
import org.j_paine.formatter.FormatElement;
import org.j_paine.formatter.FormatInputList;
import org.j_paine.formatter.InputStreamAndBuffer;
import org.j_paine.formatter.KeyNotStringOnReadException;
import org.j_paine.formatter.VectorAndPointer;

final class StringsHashtableAndPointer
implements FormatInputList {
    private VectorAndPointer vp;
    private Hashtable ht;

    public StringsHashtableAndPointer(Vector vector, Hashtable hashtable) {
        this.vp = new VectorAndPointer(vector);
        this.ht = hashtable;
    }

    @Override
    public void checkCurrentElementForRead(FormatElement formatElement, InputStreamAndBuffer inputStreamAndBuffer) throws EndOfKeyVectorOnReadException {
        if (!this.vp.hasCurrentElement()) {
            throw new EndOfKeyVectorOnReadException(this.vp.getPtr(), formatElement.toString(), inputStreamAndBuffer.getLineErrorReport());
        }
    }

    @Override
    public void putElementAndAdvance(Object object, FormatElement formatElement, InputStreamAndBuffer inputStreamAndBuffer) throws KeyNotStringOnReadException {
        Object object2 = this.vp.getCurrentElement();
        if (!(object2 instanceof String)) {
            throw new KeyNotStringOnReadException(object2, this.vp.getPtr(), formatElement.toString(), inputStreamAndBuffer.getLineErrorReport());
        }
        this.ht.put((String)object2, object);
        this.vp.advance();
    }

    @Override
    public int getPtr() {
        return this.vp.getPtr();
    }
}

